/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.expando.exportimport.internal.staged.model.repository;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.adapter.StagedExpandoColumn;
import com.liferay.expando.kernel.model.adapter.StagedExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.adapter.ModelAdapterUtil;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.expando.kernel.model.adapter.StagedExpandoColumn"}, service={StagedModelRepository.class})
public class StagedExpandoColumnStagedModelRepository
implements StagedModelRepository<StagedExpandoColumn> {
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExportImportHelper _exportImportHelper;
    private StagedModelRepository<StagedExpandoTable> _stagedExpandoTableStagedModelRepository;

    public StagedExpandoColumn addStagedModel(PortletDataContext portletDataContext, StagedExpandoColumn stagedExpandoColumn) throws PortalException {
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.addColumn(stagedExpandoColumn.getTableId(), stagedExpandoColumn.getName(), stagedExpandoColumn.getType(), (Object)stagedExpandoColumn.getDefaultData());
        expandoColumn = this._expandoColumnLocalService.updateTypeSettings(expandoColumn.getColumnId(), stagedExpandoColumn.getTypeSettings());
        return (StagedExpandoColumn)ModelAdapterUtil.adapt((Object)expandoColumn, ExpandoColumn.class, StagedExpandoColumn.class);
    }

    public void deleteStagedModel(StagedExpandoColumn stagedExpandoColumn) throws PortalException {
        this._expandoColumnLocalService.deleteColumn((ExpandoColumn)stagedExpandoColumn);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        List<StagedExpandoColumn> stagedExpandoColumns = this.fetchStagedModelsByUuidAndCompanyId(extraDataJSONObject.getString("uuid"), extraDataJSONObject.getInt("companyId"));
        if (ListUtil.isEmpty(stagedExpandoColumns)) {
            return;
        }
        for (StagedExpandoColumn stagedExpandoColumn : stagedExpandoColumns) {
            this.deleteStagedModel(stagedExpandoColumn);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        List expandoColumns = this._expandoColumnLocalService.getExpandoColumns(-1, -1);
        for (ExpandoColumn expandoColumn : expandoColumns) {
            this._expandoColumnLocalService.deleteColumn(expandoColumn);
        }
    }

    public StagedExpandoColumn fetchMissingReference(String uuid, long groupId) {
        return null;
    }

    public StagedExpandoColumn fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return null;
    }

    public List<StagedExpandoColumn> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        DynamicQuery dynamicQuery = this._expandoColumnLocalService.dynamicQuery();
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        List stagedExpandoTables = this._stagedExpandoTableStagedModelRepository.fetchStagedModelsByUuidAndCompanyId(this._parseExpandoTableUuid(uuid), companyId);
        if (ListUtil.isEmpty((List)stagedExpandoTables)) {
            return null;
        }
        StagedExpandoTable stagedExpandoTable = (StagedExpandoTable)stagedExpandoTables.get(0);
        Property tableIdProperty = PropertyFactoryUtil.forName((String)"tableId");
        dynamicQuery.add(tableIdProperty.eq((Object)stagedExpandoTable.getTableId()));
        Property nameProperty = PropertyFactoryUtil.forName((String)"name");
        String name = this._parseExpandoColumnName(uuid);
        dynamicQuery.add(nameProperty.eq((Object)name));
        List expandoColumns = this._expandoColumnLocalService.dynamicQuery(dynamicQuery);
        if (ListUtil.isNotEmpty((List)expandoColumns)) {
            return ModelAdapterUtil.adapt((List)expandoColumns, ExpandoColumn.class, StagedExpandoColumn.class);
        }
        return Collections.emptyList();
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = StagedExpandoColumnStagedModelRepository.this._exportImportHelper.getModelDeletionCount(portletDataContext, stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        exportActionableDynamicQuery.setBaseLocalService((BaseLocalService)this._expandoColumnLocalService);
        Class<?> expandoColumnLocalServiceClass = this._expandoColumnLocalService.getClass();
        exportActionableDynamicQuery.setClassLoader(expandoColumnLocalServiceClass.getClassLoader());
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setModelClass(ExpandoColumn.class);
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ExpandoColumn>(){

            public void performAction(ExpandoColumn expandoColumn) throws PortalException {
                StagedExpandoColumn stagedExpandoColumn = (StagedExpandoColumn)ModelAdapterUtil.adapt((Object)expandoColumn, ExpandoColumn.class, StagedExpandoColumn.class);
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedExpandoColumn);
            }
        });
        exportActionableDynamicQuery.setPrimaryKeyPropertyName("tableId");
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(StagedExpandoColumn.class));
        return exportActionableDynamicQuery;
    }

    public void restoreStagedModel(PortletDataContext portletDataContext, StagedExpandoColumn stagedModel) throws PortletDataException {
    }

    public StagedExpandoColumn saveStagedModel(StagedExpandoColumn stagedExpandoColumn) throws PortalException {
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.updateExpandoColumn((ExpandoColumn)stagedExpandoColumn);
        return (StagedExpandoColumn)ModelAdapterUtil.adapt((Object)expandoColumn, ExpandoColumn.class, StagedExpandoColumn.class);
    }

    public StagedExpandoColumn updateStagedModel(PortletDataContext portletDataContext, StagedExpandoColumn stagedExpandoColumn) throws PortalException {
        this._expandoColumnLocalService.updateColumn(stagedExpandoColumn.getColumnId(), stagedExpandoColumn.getName(), stagedExpandoColumn.getType(), (Object)stagedExpandoColumn.getDefaultData());
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.updateTypeSettings(stagedExpandoColumn.getColumnId(), stagedExpandoColumn.getTypeSettings());
        return (StagedExpandoColumn)ModelAdapterUtil.adapt((Object)expandoColumn, ExpandoColumn.class, StagedExpandoColumn.class);
    }

    @Reference(target="(model.class.name=com.liferay.expando.kernel.model.adapter.StagedExpandoTable)", unbind="-")
    protected void setStagedExpandoTableStagedModelRepository(StagedModelRepository<StagedExpandoTable> stagedExpandoTableStagedModelRepository) {
        this._stagedExpandoTableStagedModelRepository = stagedExpandoTableStagedModelRepository;
    }

    private String _parseExpandoColumnName(String uuid) {
        return uuid.substring(uuid.lastIndexOf("#") + 1);
    }

    private String _parseExpandoTableUuid(String uuid) {
        return uuid.substring(0, uuid.lastIndexOf("#"));
    }
}

