/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueValidator;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.NumberUtil;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.dynamic.data.mapping.validator.internal.expression.DDMFormFieldValueExpressionParameterAccessor;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormValuesValidator.class})
public class DDMFormValuesValidatorImpl
implements DDMFormValuesValidator {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesValidatorImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    private DDMFormFieldValueExpressionParameterAccessor _ddmFormFieldValueExpressionParameterAccessor;
    private final DDMFormFieldValueAccessor<String> _defaultDDMFormFieldValueAccessor = new DefaultDDMFormFieldValueAccessor();
    @Reference
    private JSONFactory _jsonFactory;
    private ServiceTrackerMap<String, DDMFormFieldValueValidator> _serviceTrackerMap;

    public void validate(DDMFormValues ddmFormValues) throws DDMFormValuesValidationException {
        this.validate(ddmFormValues, null);
    }

    public void validate(DDMFormValues ddmFormValues, String timeZoneId) throws DDMFormValuesValidationException {
        this._ddmFormFieldValueExpressionParameterAccessor = new DDMFormFieldValueExpressionParameterAccessor(this._jsonFactory, ddmFormValues.getDefaultLocale(), timeZoneId);
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        if (ddmForm == null) {
            throw new NullPointerException("A DDM Form instance was never set");
        }
        this._traverseDDMFormFields(ddmForm.getDDMFormFields(), ddmFormValues.getDDMFormFieldValuesMap());
        this._traverseDDMFormFieldValues(ddmFormValues.getDDMFormFieldValues(), ddmForm.getDDMFormFieldsMap(false));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMFormFieldValueValidator.class, (String)"ddm.form.field.type.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected Boolean evaluateValidationExpression(String dataType, String ddmFormFieldName, DDMFormFieldValidation ddmFormFieldValidation, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        Locale locale;
        if (ddmFormFieldValue.getValue() == null) {
            return true;
        }
        Value value = ddmFormFieldValue.getValue();
        if (Validator.isNull((String)value.getString(locale = value.getDefaultLocale()))) {
            return true;
        }
        DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
        if (ddmFormFieldValidationExpression == null || Validator.isNull((String)ddmFormFieldValidationExpression.getValue())) {
            return true;
        }
        DDMExpression ddmExpression = null;
        try {
            if (ddmFormFieldValidation.getParameterLocalizedValue() != null) {
                LocalizedValue parameterLocalizedValue = ddmFormFieldValidation.getParameterLocalizedValue();
                ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)ddmFormFieldValidationExpression.getExpression(ddmFormFieldValue.getDDMFormValues(), parameterLocalizedValue.getString(locale), this._ddmFormFieldValueExpressionParameterAccessor.getTimeZoneId())).withDDMExpressionParameterAccessor((DDMExpressionParameterAccessor)this._ddmFormFieldValueExpressionParameterAccessor).build());
            } else {
                ddmExpression = this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)ddmFormFieldValidationExpression.getValue()).build());
            }
            if (dataType.equals("boolean")) {
                ddmExpression.setVariable(ddmFormFieldName, (Object)GetterUtil.getBoolean((String)value.getString(locale)));
            } else if (dataType.equals("double")) {
                String valueString = value.getString(locale);
                if (NumberUtil.hasDecimalSeparator((String)valueString)) {
                    ddmExpression.setVariable(ddmFormFieldName, (Object)GetterUtil.getDouble((String)valueString, (Locale)locale));
                } else {
                    ddmExpression.setVariable(ddmFormFieldName, (Object)GetterUtil.getInteger((String)valueString));
                }
            } else if (dataType.equals("integer")) {
                ddmExpression.setVariable(ddmFormFieldName, (Object)GetterUtil.getInteger((String)value.getString(locale)));
            } else {
                ddmExpression.setVariable(ddmFormFieldName, (Object)value.getString(locale));
            }
            return (Boolean)ddmExpression.evaluate();
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new DDMFormValuesValidationException((Throwable)ddmExpressionException);
        }
    }

    protected boolean isNull(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        if (value == null || SetUtil.isEmpty((Set)value.getAvailableLocales())) {
            return true;
        }
        DDMFormFieldValueAccessor<?> ddmFormFieldValueAccessor = this._getDDMFormFieldValueAccessor(ddmFormField.getType());
        Set locales = value.getAvailableLocales();
        Stream stream = locales.stream();
        return stream.allMatch(locale -> ddmFormFieldValueAccessor.isEmpty(ddmFormFieldValue, locale));
    }

    protected void validateDDMFormFieldValidationExpression(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation == null) {
            return;
        }
        Boolean valid = this.evaluateValidationExpression(ddmFormField.getDataType(), ddmFormField.getName(), ddmFormFieldValidation, ddmFormFieldValue);
        if (!Objects.equals(Boolean.TRUE, valid)) {
            throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getLabel(), ddmFormField.getName());
        }
    }

    private DDMFormFieldValueAccessor<?> _getDDMFormFieldValueAccessor(String type) {
        DDMFormFieldValueAccessor ddmFormFieldValueAccessor = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldValueAccessor(type);
        if (ddmFormFieldValueAccessor != null) {
            return ddmFormFieldValueAccessor;
        }
        return this._defaultDDMFormFieldValueAccessor;
    }

    private List<DDMFormFieldValue> _getDDMFormFieldValuesByFieldName(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, String fieldName) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
        if (ddmFormFieldValues == null) {
            return Collections.emptyList();
        }
        return ddmFormFieldValues;
    }

    private void _invokeDDMFormFieldValueValidator(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        DDMFormFieldValueValidator ddmFormFieldValueValidator = (DDMFormFieldValueValidator)this._serviceTrackerMap.getService((Object)ddmFormField.getType());
        if (ddmFormFieldValueValidator == null) {
            return;
        }
        try {
            ddmFormFieldValueValidator.validate(ddmFormField, ddmFormFieldValue.getValue());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Value is invalid for field " + ddmFormField.getName()), (Throwable)exception);
            }
            throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getLabel(), ddmFormField.getName());
        }
    }

    private void _traverseDDMFormFields(List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) throws DDMFormValuesValidationException {
        for (DDMFormField ddmFormField : ddmFormFields) {
            List<DDMFormFieldValue> ddmFormFieldValues = this._getDDMFormFieldValuesByFieldName(ddmFormFieldValuesMap, ddmFormField.getName());
            this._validateDDMFormFieldValues(ddmFormField, ddmFormFieldValues);
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                this._traverseDDMFormFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue.getNestedDDMFormFieldValuesMap());
            }
        }
    }

    private void _traverseDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, Map<String, DDMFormField> ddmFormFieldsMap) throws DDMFormValuesValidationException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
            if (ddmFormField == null) continue;
            this._validateDDMFormFieldValue(ddmFormFieldsMap.get(ddmFormFieldValue.getName()), ddmFormFieldValue);
            this._traverseDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFormField.getNestedDDMFormFieldsMap());
        }
    }

    private void _validateDDMFormFieldValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        if (ddmFormField == null) {
            throw new DDMFormValuesValidationException.MustSetValidField(ddmFormField.getLabel(), ddmFormFieldValue.getName());
        }
        DDMFormValues ddmFormValues = ddmFormFieldValue.getDDMFormValues();
        this._validateDDMFormFieldValue(ddmFormField, ddmFormValues.getAvailableLocales(), ddmFormValues.getDefaultLocale(), ddmFormFieldValue);
        this._invokeDDMFormFieldValueValidator(ddmFormField, ddmFormFieldValue);
        this._traverseDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFormField.getNestedDDMFormFieldsMap());
    }

    private void _validateDDMFormFieldValue(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        Value value = ddmFormFieldValue.getValue();
        if (Validator.isNull((String)ddmFormField.getDataType())) {
            if (value != null) {
                throw new DDMFormValuesValidationException.MustNotSetValue(ddmFormField.getLabel(), ddmFormField.getName());
            }
        } else {
            if (value == null || ddmFormField.isRequired() && this.isNull(ddmFormField, ddmFormFieldValue)) {
                throw new DDMFormValuesValidationException.RequiredValue(ddmFormField.getLabel(), ddmFormField.getName());
            }
            if (ddmFormField.isLocalizable() && !value.isLocalized() || !ddmFormField.isLocalizable() && value.isLocalized()) {
                throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getLabel(), ddmFormField.getName());
            }
            this._validateDDMFormFieldValueLocales(ddmFormField, availableLocales, defaultLocale, value);
            this.validateDDMFormFieldValidationExpression(ddmFormField, ddmFormFieldValue);
        }
    }

    private void _validateDDMFormFieldValueLocales(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, Value value) throws DDMFormValuesValidationException {
        if (!value.isLocalized()) {
            return;
        }
        if (!availableLocales.equals(value.getAvailableLocales())) {
            throw new DDMFormValuesValidationException.MustSetValidAvailableLocales(ddmFormField.getLabel(), ddmFormField.getName());
        }
        if (!defaultLocale.equals(value.getDefaultLocale())) {
            throw new DDMFormValuesValidationException.MustSetValidDefaultLocale(ddmFormField.getLabel(), ddmFormField.getName());
        }
    }

    private void _validateDDMFormFieldValues(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues) throws DDMFormValuesValidationException {
        if (ddmFormField.isRequired() && ddmFormFieldValues.isEmpty()) {
            throw new DDMFormValuesValidationException.RequiredValue(ddmFormField.getLabel(), ddmFormField.getName());
        }
        if (!ddmFormField.isRepeatable() && ddmFormFieldValues.size() > 1) {
            throw new DDMFormValuesValidationException.MustSetValidValuesSize(ddmFormField.getLabel(), ddmFormField.getName());
        }
    }
}

