/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.dynamic.data.mapping.validator.internal.expression;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;

import java.util.Locale;

/**
 * @author Carolina Barbosa
 * @author Renato Rego
 */
public class DDMFormFieldValueExpressionParameterAccessor
	implements DDMExpressionParameterAccessor {

	public DDMFormFieldValueExpressionParameterAccessor(
		JSONFactory jsonFactory, Locale locale, String timeZoneId) {

		_jsonFactory = jsonFactory;
		_locale = locale;
		_timeZoneId = timeZoneId;
	}

	@Override
	public long getCompanyId() {
		return 0L;
	}

	@Override
	public String getGooglePlacesAPIKey() {
		return StringPool.BLANK;
	}

	@Override
	public long getGroupId() {
		return 0L;
	}

	@Override
	public Locale getLocale() {
		return _locale;
	}

	@Override
	public JSONArray getObjectFieldsJSONArray() {
		return _jsonFactory.createJSONArray();
	}

	@Override
	public String getTimeZoneId() {
		return _timeZoneId;
	}

	@Override
	public long getUserId() {
		return 0L;
	}

	private final JSONFactory _jsonFactory;
	private final Locale _locale;
	private final String _timeZoneId;

}