/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={DDMFormLayoutValidator.class})
public class DDMFormLayoutValidatorImpl
implements DDMFormLayoutValidator {
    private static final int _MAX_ROW_SIZE = 12;

    public void validate(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        this.validateDDMFormLayoutDefaultLocale(ddmFormLayout);
        this._validateDDMFormFieldNames(ddmFormLayout);
        this._validateDDMFormLayoutPageTitles(ddmFormLayout);
        this._validateDDMFormLayoutRowSizes(ddmFormLayout);
    }

    protected void validateDDMFormLayoutDefaultLocale(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        Locale defaultLocale = ddmFormLayout.getDefaultLocale();
        if (defaultLocale == null) {
            throw new DDMFormLayoutValidationException.MustSetDefaultLocale();
        }
    }

    private Stream<String> _getDDMFormFieldNamesStream(DDMFormLayoutColumn ddmFormLayoutColumn) {
        List ddmFormFieldNames = ddmFormLayoutColumn.getDDMFormFieldNames();
        return ddmFormFieldNames.stream();
    }

    private Stream<DDMFormLayoutColumn> _getDDMFormLayoutColumnStream(DDMFormLayoutRow ddmFormLayoutRow) {
        List ddmFormLayoutColumns = ddmFormLayoutRow.getDDMFormLayoutColumns();
        return ddmFormLayoutColumns.stream();
    }

    private Stream<DDMFormLayoutRow> _getDDMFormLayoutRowStream(DDMFormLayoutPage ddmFormLayoutPage) {
        List ddmFormLayoutRows = ddmFormLayoutPage.getDDMFormLayoutRows();
        return ddmFormLayoutRows.stream();
    }

    private void _validateDDMFormFieldNames(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        List ddmFormLayoutPages = ddmFormLayout.getDDMFormLayoutPages();
        Stream stream = ddmFormLayoutPages.stream();
        Map<String, Long> ddmFormFieldNamesCount = stream.flatMap(this::_getDDMFormLayoutRowStream).flatMap(this::_getDDMFormLayoutColumnStream).flatMap(this::_getDDMFormFieldNamesStream).collect(Collectors.groupingBy(String::valueOf, Collectors.counting()));
        Set<Map.Entry<String, Long>> entrySet = ddmFormFieldNamesCount.entrySet();
        Stream entrySetStream = entrySet.stream();
        Set duplicatedFieldNames = entrySetStream.filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (SetUtil.isNotEmpty(duplicatedFieldNames)) {
            throw new DDMFormLayoutValidationException.MustNotDuplicateFieldName(duplicatedFieldNames);
        }
    }

    private void _validateDDMFormLayoutPageTitles(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        Locale defaultLocale = ddmFormLayout.getDefaultLocale();
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            LocalizedValue title = ddmFormLayoutPage.getTitle();
            if (defaultLocale.equals(title.getDefaultLocale())) continue;
            throw new DDMFormLayoutValidationException.MustSetEqualLocaleForLayoutAndTitle();
        }
    }

    private void _validateDDMFormLayoutRowSizes(DDMFormLayout ddmFormLayout) throws DDMFormLayoutValidationException {
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout.getDDMFormLayoutPages()) {
            for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutPage.getDDMFormLayoutRows()) {
                int rowSize = 0;
                for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                    int columnSize = ddmFormLayoutColumn.getSize();
                    if (columnSize <= 0 || columnSize > 12) {
                        throw new DDMFormLayoutValidationException.InvalidColumnSize();
                    }
                    rowSize += ddmFormLayoutColumn.getSize();
                }
                if (rowSize == 12) continue;
                throw new DDMFormLayoutValidationException.InvalidRowSize();
            }
        }
    }
}

