/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueValidationException;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueValidator;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.dynamic.data.mapping.validator.internal.util.DDMFormRuleValidatorUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormValidator.class})
public class DDMFormValidatorImpl
implements DDMFormValidator {
    private static final String[] _DDM_FORM_FIELD_INDEX_TYPES = new String[]{"", "keyword", "none", "text"};
    private static final Pattern _ddmFormFieldNamePattern = Pattern.compile("([^\\p{Punct}|\\p{Space}$]|_)+");
    private static final Pattern _ddmFormFieldTypePattern = Pattern.compile("([^\\p{Punct}|\\p{Space}$]|[-_])+");
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference(target="(ddm.form.field.type.name=grid)")
    private DDMFormFieldValueValidator _ddmFormFieldValueValidator;

    public void validate(DDMForm ddmForm) throws DDMFormFieldValueValidationException, DDMFormValidationException {
        DDMFormRuleValidatorUtil.validateDDMFormRules(this._ddmExpressionFactory, ddmForm.getDDMFormRules());
        this.validateDDMFormLocales(ddmForm);
        List ddmFormFields = ddmForm.getDDMFormFields();
        if (ddmFormFields.isEmpty()) {
            throw new DDMFormValidationException.MustSetFieldsForForm();
        }
        this.validateDDMFormFields(ddmFormFields, new HashSet<String>(), ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
    }

    @Reference(unbind="-")
    protected void setDDMExpressionFactory(DDMExpressionFactory ddmExpressionFactory) {
        this._ddmExpressionFactory = ddmExpressionFactory;
    }

    protected void validateDDMFormAvailableLocales(Set<Locale> availableLocales, Locale defaultLocale) throws DDMFormValidationException {
        if (availableLocales == null || availableLocales.isEmpty()) {
            throw new DDMFormValidationException.MustSetAvailableLocales();
        }
        if (!availableLocales.contains(defaultLocale)) {
            throw new DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale(defaultLocale);
        }
    }

    protected void validateDDMFormFieldGrid(DDMFormField ddmFormField) throws DDMFormFieldValueValidationException {
        String fieldType = ddmFormField.getType();
        if (fieldType.equals("grid")) {
            this._ddmFormFieldValueValidator.validate(ddmFormField, null);
        }
    }

    protected void validateDDMFormFieldIndexType(DDMFormField ddmFormField) throws DDMFormValidationException {
        if (!ArrayUtil.contains((Object[])_DDM_FORM_FIELD_INDEX_TYPES, (Object)ddmFormField.getIndexType())) {
            throw new DDMFormValidationException.MustSetValidIndexType(ddmFormField.getName());
        }
    }

    protected void validateDDMFormFieldName(DDMFormField ddmFormField, Set<String> ddmFormFieldNames) throws DDMFormValidationException {
        Matcher matcher = _ddmFormFieldNamePattern.matcher(ddmFormField.getName());
        if (!matcher.matches()) {
            throw new DDMFormValidationException.MustSetValidCharactersForFieldName(ddmFormField.getName());
        }
        if (ddmFormFieldNames.contains(StringUtil.toLowerCase((String)ddmFormField.getName()))) {
            throw new DDMFormValidationException.MustNotDuplicateFieldName(ddmFormField.getName());
        }
        ddmFormFieldNames.add(StringUtil.toLowerCase((String)ddmFormField.getName()));
    }

    protected void validateDDMFormFieldOptions(DDMFormField ddmFormField, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        String fieldType = ddmFormField.getType();
        if (!(fieldType.equals("checkbox_multiple") || fieldType.equals("radio") || fieldType.equals("select"))) {
            return;
        }
        String dataSourceType = GetterUtil.getString((Object)ddmFormField.getProperty("dataSourceType"), (String)"manual");
        if (!Objects.equals(dataSourceType, "manual")) {
            return;
        }
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        Set optionValues = Collections.emptySet();
        if (ddmFormFieldOptions != null) {
            optionValues = ddmFormFieldOptions.getOptionsValues();
        }
        if (optionValues.isEmpty()) {
            throw new DDMFormValidationException.MustSetOptionsForField(ddmFormField.getName());
        }
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            LocalizedValue localizedValue = ddmFormFieldOptions.getOptionLabels(optionValue);
            this.validateDDMFormFieldPropertyValue(ddmFormField.getName(), "options", localizedValue, ddmFormAvailableLocales, ddmFormDefaultLocale);
        }
    }

    protected void validateDDMFormFieldPropertyValue(String fieldName, String propertyName, LocalizedValue propertyValue, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        if (!ddmFormDefaultLocale.equals(propertyValue.getDefaultLocale())) {
            throw new DDMFormValidationException.MustSetValidDefaultLocaleForProperty(fieldName, propertyName);
        }
        if (!ddmFormAvailableLocales.equals(propertyValue.getAvailableLocales())) {
            throw new DDMFormValidationException.MustSetValidAvailableLocalesForProperty(fieldName, propertyName);
        }
    }

    protected void validateDDMFormFields(List<DDMFormField> ddmFormFields, Set<String> ddmFormFieldNames, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormFieldValueValidationException, DDMFormValidationException {
        for (DDMFormField ddmFormField : ddmFormFields) {
            this.validateDDMFormFieldName(ddmFormField, ddmFormFieldNames);
            this.validateDDMFormFieldType(ddmFormField);
            this.validateDDMFormFieldIndexType(ddmFormField);
            this.validateDDMFormFieldOptions(ddmFormField, ddmFormAvailableLocales, ddmFormDefaultLocale);
            this.validateDDMFormFieldGrid(ddmFormField);
            this.validateOptionalDDMFormFieldLocalizedProperty(ddmFormField, "label", ddmFormAvailableLocales, ddmFormDefaultLocale);
            this.validateOptionalDDMFormFieldLocalizedProperty(ddmFormField, "tip", ddmFormAvailableLocales, ddmFormDefaultLocale);
            this.validateDDMFormFieldValidationExpression(ddmFormField, ddmFormAvailableLocales);
            this.validateDDMFormFieldVisibilityExpression(ddmFormField);
            this.validateDDMFormFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldNames, ddmFormAvailableLocales, ddmFormDefaultLocale);
        }
    }

    protected void validateDDMFormFieldType(DDMFormField ddmFormField) throws DDMFormValidationException {
        if (Validator.isNull((String)ddmFormField.getType())) {
            throw new DDMFormValidationException.MustSetFieldType(ddmFormField.getName());
        }
        Matcher matcher = _ddmFormFieldTypePattern.matcher(ddmFormField.getType());
        if (!matcher.matches()) {
            throw new DDMFormValidationException.MustSetValidCharactersForFieldType(ddmFormField.getType());
        }
    }

    protected void validateDDMFormFieldValidationExpression(DDMFormField ddmFormField, Set<Locale> locales) throws DDMFormValidationException {
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation == null) {
            return;
        }
        DDMFormFieldValidationExpression ddmFormFieldValidationExpression = ddmFormFieldValidation.getDDMFormFieldValidationExpression();
        if (ddmFormFieldValidationExpression == null || Validator.isNull((String)ddmFormFieldValidationExpression.getValue())) {
            return;
        }
        try {
            if (ddmFormFieldValidation.getParameterLocalizedValue() == null) {
                this._ddmExpressionFactory.createBooleanDDMExpression(ddmFormFieldValidationExpression.getValue());
            } else {
                String value = ddmFormFieldValidationExpression.getValue();
                LocalizedValue parameterLocalizedValue = ddmFormFieldValidation.getParameterLocalizedValue();
                for (Locale locale : locales) {
                    this._ddmExpressionFactory.createBooleanDDMExpression(StringUtil.replace((String)value, (String)"{parameter}", (String)parameterLocalizedValue.getString(locale)));
                }
            }
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new DDMFormValidationException.MustSetValidValidationExpression(ddmFormField.getName(), ddmFormFieldValidationExpression.getValue());
        }
    }

    protected void validateDDMFormFieldVisibilityExpression(DDMFormField ddmFormField) throws DDMFormValidationException {
        String visibilityExpression = ddmFormField.getVisibilityExpression();
        if (Validator.isNull((String)visibilityExpression)) {
            return;
        }
        try {
            this._ddmExpressionFactory.createBooleanDDMExpression(visibilityExpression);
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new DDMFormValidationException.MustSetValidVisibilityExpression(ddmFormField.getName(), visibilityExpression);
        }
    }

    protected void validateDDMFormLocales(DDMForm ddmForm) throws DDMFormValidationException {
        Locale defaultLocale = ddmForm.getDefaultLocale();
        if (defaultLocale == null) {
            throw new DDMFormValidationException.MustSetDefaultLocale();
        }
        this.validateDDMFormAvailableLocales(ddmForm.getAvailableLocales(), defaultLocale);
    }

    protected void validateOptionalDDMFormFieldLocalizedProperty(DDMFormField ddmFormField, String propertyName, Set<Locale> ddmFormAvailableLocales, Locale ddmFormDefaultLocale) throws DDMFormValidationException {
        LocalizedValue propertyValue = (LocalizedValue)BeanPropertiesUtil.getObject((Object)ddmFormField, (String)propertyName);
        if (MapUtil.isEmpty((Map)propertyValue.getValues())) {
            return;
        }
        this.validateDDMFormFieldPropertyValue(ddmFormField.getName(), propertyName, propertyValue, ddmFormAvailableLocales, ddmFormDefaultLocale);
    }
}

