/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator.internal;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldValueAccessor;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormValuesValidatorImpl
implements DDMFormValuesValidator {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesValidatorImpl.class);
    private DDMExpressionFactory _ddmExpressionFactory;
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final DDMFormFieldValueAccessor<String> _defaultDDMFormFieldValueAccessor = new DefaultDDMFormFieldValueAccessor();
    private JSONFactory _jsonFactory;

    @Override
    public void validate(DDMFormValues ddmFormValues) throws DDMFormValuesValidationException {
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        if (ddmForm == null) {
            throw new NullPointerException("A DDM Form instance was never set");
        }
        this.traverseDDMFormFields(ddmForm.getDDMFormFields(), ddmFormValues.getDDMFormFieldValuesMap());
        this.traverseDDMFormFieldValues(ddmFormValues.getDDMFormFieldValues(), ddmForm.getDDMFormFieldsMap(false));
    }

    protected JSONArray createJSONArray(String fieldName, String json) throws DDMFormValuesValidationException {
        try {
            return this._jsonFactory.createJSONArray(json);
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsone, (Throwable)jsone);
            }
            throw new DDMFormValuesValidationException.MustSetValidValue(fieldName);
        }
    }

    protected boolean evaluateValidationExpression(String expressionString, String ddmFormFieldName, String dataType, String valueString) throws DDMFormValuesValidationException {
        if (Validator.isNull((String)valueString)) {
            return true;
        }
        try {
            DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(expressionString);
            if (dataType.equals("integer")) {
                ddmExpression.setLongVariableValue(ddmFormFieldName, Long.valueOf(GetterUtil.getLong((String)valueString)));
            } else if (dataType.equals("boolean")) {
                ddmExpression.setBooleanVariableValue(ddmFormFieldName, Boolean.valueOf(GetterUtil.getBoolean((String)valueString)));
            } else {
                ddmExpression.setStringVariableValue(ddmFormFieldName, valueString);
            }
            return (Boolean)ddmExpression.evaluate();
        }
        catch (DDMExpressionException ddmee) {
            throw new DDMFormValuesValidationException(ddmee);
        }
    }

    protected DDMFormFieldValueAccessor<?> getDDMFormFieldValueAccessor(String type) {
        DDMFormFieldValueAccessor ddmFormFieldValueAccessor = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueAccessor(type);
        if (ddmFormFieldValueAccessor != null) {
            return ddmFormFieldValueAccessor;
        }
        return this._defaultDDMFormFieldValueAccessor;
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValuesByFieldName(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, String fieldName) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
        if (ddmFormFieldValues == null) {
            return Collections.emptyList();
        }
        return ddmFormFieldValues;
    }

    protected boolean isNull(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        if (value == null) {
            return true;
        }
        DDMFormFieldValueAccessor<?> ddmFormFieldValueAccessor = this.getDDMFormFieldValueAccessor(ddmFormField.getType());
        for (Locale availableLocale : value.getAvailableLocales()) {
            if (!ddmFormFieldValueAccessor.isEmpty(ddmFormFieldValue, availableLocale)) continue;
            return true;
        }
        return false;
    }

    @Reference(unbind="-")
    protected void setDDMExpressionFactory(DDMExpressionFactory ddmExpressionFactory) {
        this._ddmExpressionFactory = ddmExpressionFactory;
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void traverseDDMFormFields(List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) throws DDMFormValuesValidationException {
        for (DDMFormField ddmFormField : ddmFormFields) {
            List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValuesByFieldName(ddmFormFieldValuesMap, ddmFormField.getName());
            this.validateDDMFormFieldValues(ddmFormField, ddmFormFieldValues);
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                this.traverseDDMFormFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue.getNestedDDMFormFieldValuesMap());
            }
        }
    }

    protected void traverseDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, Map<String, DDMFormField> ddmFormFieldsMap) throws DDMFormValuesValidationException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            DDMFormField ddmFormField = ddmFormFieldsMap.get(ddmFormFieldValue.getName());
            if (!Validator.isNotNull((Object)ddmFormField)) continue;
            this.validateDDMFormFieldValue(ddmFormFieldsMap.get(ddmFormFieldValue.getName()), ddmFormFieldValue);
            this.traverseDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFormField.getNestedDDMFormFieldsMap());
        }
    }

    protected void validateDDMFormFieldOptions(DDMFormField ddmFormField, Value value) throws DDMFormValuesValidationException {
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions == null) {
            return;
        }
        Set optionValues = ddmFormFieldOptions.getOptionsValues();
        if (optionValues.isEmpty()) {
            return;
        }
        Map selectedValues = value.getValues();
        for (String selectedValue : selectedValues.values()) {
            JSONArray jsonArray = this.createJSONArray(ddmFormField.getName(), selectedValue);
            for (int i = 0; i < jsonArray.length(); ++i) {
                if (Validator.isNull((String)jsonArray.getString(i)) && !ddmFormField.isRequired() || optionValues.contains(jsonArray.getString(i))) continue;
                throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getName());
            }
        }
    }

    protected void validateDDMFormFieldValidationExpression(DDMFormField ddmFormField, Value value) throws DDMFormValuesValidationException {
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation == null) {
            return;
        }
        String validationExpression = ddmFormFieldValidation.getExpression();
        if (Validator.isNull((String)validationExpression)) {
            return;
        }
        for (Locale locale : value.getAvailableLocales()) {
            boolean valid = this.evaluateValidationExpression(validationExpression, ddmFormField.getName(), ddmFormField.getDataType(), value.getString(locale));
            if (valid) continue;
            throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getName());
        }
    }

    protected void validateDDMFormFieldValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        if (ddmFormField == null) {
            throw new DDMFormValuesValidationException.MustSetValidField(ddmFormFieldValue.getName());
        }
        DDMFormValues ddmFormValues = ddmFormFieldValue.getDDMFormValues();
        this.validateDDMFormFieldValue(ddmFormField, ddmFormValues.getAvailableLocales(), ddmFormValues.getDefaultLocale(), ddmFormFieldValue);
        this.traverseDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFormField.getNestedDDMFormFieldsMap());
    }

    protected void validateDDMFormFieldValue(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, DDMFormFieldValue ddmFormFieldValue) throws DDMFormValuesValidationException {
        Value value = ddmFormFieldValue.getValue();
        if (Validator.isNull((String)ddmFormField.getDataType())) {
            if (value != null) {
                throw new DDMFormValuesValidationException.MustNotSetValue(ddmFormField.getName());
            }
        } else {
            if (value == null || ddmFormField.isRequired() && this.isNull(ddmFormField, ddmFormFieldValue)) {
                throw new DDMFormValuesValidationException.RequiredValue(ddmFormField.getName());
            }
            if (ddmFormField.isLocalizable() && !value.isLocalized() || !ddmFormField.isLocalizable() && value.isLocalized()) {
                throw new DDMFormValuesValidationException.MustSetValidValue(ddmFormField.getName());
            }
            this.validateDDMFormFieldValueLocales(ddmFormField, availableLocales, defaultLocale, value);
            this.validateDDMFormFieldValidationExpression(ddmFormField, value);
            this.validateDDMFormFieldOptions(ddmFormField, value);
        }
    }

    protected void validateDDMFormFieldValueLocales(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, Value value) throws DDMFormValuesValidationException {
        if (!value.isLocalized()) {
            return;
        }
        if (!availableLocales.equals(value.getAvailableLocales())) {
            throw new DDMFormValuesValidationException.MustSetValidAvailableLocales(ddmFormField.getName());
        }
        if (!defaultLocale.equals(value.getDefaultLocale())) {
            throw new DDMFormValuesValidationException.MustSetValidDefaultLocale(ddmFormField.getName());
        }
    }

    protected void validateDDMFormFieldValues(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues) throws DDMFormValuesValidationException {
        if (ddmFormField.isRequired() && ddmFormFieldValues.isEmpty()) {
            throw new DDMFormValuesValidationException.RequiredValue(ddmFormField.getName());
        }
        if (!ddmFormField.isRepeatable() && ddmFormFieldValues.size() > 1) {
            throw new DDMFormValuesValidationException.MustSetValidValuesSize(ddmFormField.getName());
        }
    }
}

