/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v4_3_2;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DDMTemplateUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeDDMTemplate();
        this._upgradeDDMTemplateVersion();
    }

    private void _upgradeDDMTemplate() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, templateId, script FROM DDMTemplate where classNameId = ?");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplate set script = ? where ctCollectionId = ? and templateId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId(DDMStructure.class));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    preparedStatement2.setString(1, StringUtil.replace((String)resultSet.getString("script"), (String)"randomizer.", (String)"random."));
                    preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                    preparedStatement2.setLong(3, resultSet.getLong("templateId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    private void _upgradeDDMTemplateVersion() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, templateVersionId, script FROM DDMTemplateVersion where classNameId = ?");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplateVersion set script = ? where ctCollectionId = ? and templateVersionId = ?");){
            preparedStatement1.setLong(1, PortalUtil.getClassNameId(DDMStructure.class));
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    preparedStatement2.setString(1, StringUtil.replace((String)resultSet.getString("script"), (String)"randomizer.", (String)"random."));
                    preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                    preparedStatement2.setLong(3, resultSet.getLong("templateVersionId"));
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

