/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterResponse;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.CSVUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"ddm.form.instance.record.writer.type=csv"}, service={DDMFormInstanceRecordWriter.class})
public class DDMFormInstanceRecordCSVWriter
implements DDMFormInstanceRecordWriter {
    public DDMFormInstanceRecordWriterResponse write(DDMFormInstanceRecordWriterRequest ddmFormInstanceRecordWriterRequest) throws Exception {
        StringBundler sb = new StringBundler(3);
        Map ddmFormFieldsLabel = ddmFormInstanceRecordWriterRequest.getDDMFormFieldsLabel();
        sb.append(this.writeValues(ddmFormFieldsLabel.values()));
        sb.append("\n");
        sb.append(this.writeRecords(ddmFormInstanceRecordWriterRequest.getDDMFormFieldValues()));
        String csv = sb.toString();
        DDMFormInstanceRecordWriterResponse.Builder builder = DDMFormInstanceRecordWriterResponse.Builder.newBuilder((byte[])csv.getBytes());
        return builder.build();
    }

    protected String writeRecords(List<Map<String, String>> ddmFormFieldValues) {
        StringBundler sb = new StringBundler(ddmFormFieldValues.size() * 2);
        for (Map<String, String> ddmFormFieldValue : ddmFormFieldValues) {
            sb.append(this.writeValues(ddmFormFieldValue.values()));
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    protected String writeValues(Collection<String> values) {
        StringBundler sb = new StringBundler(values.size() * 2);
        for (String value : values) {
            sb.append(CSVUtil.encode((String)value));
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }
}

