/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.depot.group.provider.SiteConnectedGroupGroupProvider;
import com.liferay.dynamic.data.mapping.exception.DuplicateDDMStructureExternalReferenceCodeException;
import com.liferay.dynamic.data.mapping.exception.InvalidParentStructureException;
import com.liferay.dynamic.data.mapping.exception.InvalidStructureVersionException;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureLayoutException;
import com.liferay.dynamic.data.mapping.exception.RequiredStructureException;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateElementException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateStructureKeyException;
import com.liferay.dynamic.data.mapping.exception.StructureNameException;
import com.liferay.dynamic.data.mapping.internal.search.util.DDMSearchUtil;
import com.liferay.dynamic.data.mapping.internal.util.DDMFormTemplateSynchonizer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstanceLink;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureTable;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMDataProviderInstanceLinkPersistence;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureLayoutPersistence;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureLinkPersistence;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructurePersistence;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureVersionPersistence;
import com.liferay.dynamic.data.mapping.service.persistence.DDMTemplatePersistence;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMDataDefinitionConverter;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldUtil;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.journal.model.JournalArticle;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure"}, service={AopService.class})
public class DDMStructureLocalServiceImpl
extends DDMStructureLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureLocalServiceImpl.class);
    private static final Pattern _callFunctionPattern = Pattern.compile("call\\(\\s*'([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})'\\s*,\\s*'(.*)'\\s*,\\s*'(.*)'\\s*\\)");
    private static final Snapshot<SiteConnectedGroupGroupProvider> _siteConnectedGroupGroupProviderSnapshot = new Snapshot(DDMStructureLocalServiceImpl.class, SiteConnectedGroupGroupProvider.class, null, true);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private DDM _ddm;
    @Reference
    private DDMDataDefinitionConverter _ddmDataDefinitionConverter;
    @Reference
    private DDMDataProviderInstanceLinkLocalService _ddmDataProviderInstanceLinkLocalService;
    @Reference
    private DDMDataProviderInstanceLinkPersistence _ddmDataProviderInstanceLinkPersistence;
    @Reference
    private DDMDataProviderInstanceLocalService _ddmDataProviderInstanceLocalService;
    @Reference
    private DDMFormValidator _ddmFormValidator;
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLayoutPersistence _ddmStructureLayoutPersistence;
    @Reference
    private DDMStructureLinkPersistence _ddmStructureLinkPersistence;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private DDMStructureVersionPersistence _ddmStructureVersionPersistence;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DDMTemplatePersistence _ddmTemplatePersistence;
    @Reference(target="(ddm.form.deserializer.type=json)")
    private DDMFormDeserializer _jsonDDMFormDeserializer;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _jsonDDMFormSerializer;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    private ServiceTrackerMap<String, DDMStructureIndexer> _serviceTrackerMap;
    @Reference
    private UserLocalService _userLocalService;

    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, ServiceContext serviceContext) throws PortalException {
        return this.addStructure(null, userId, groupId, 0L, classNameId, null, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, 0, serviceContext);
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructure parentStructure = this.fetchStructure(groupId, classNameId, parentStructureKey);
        long parentStructureId = 0L;
        if (parentStructure != null) {
            parentStructureId = parentStructure.getStructureId();
        }
        return this.addStructure(null, userId, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure addStructure(String externalReferenceCode, long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        if (classNameId == this._classNameLocalService.getClassNameId(JournalArticle.class)) {
            long parentStructureLayoutId = 0L;
            if (parentStructureId > 0L) {
                DDMStructure ddmStructure = this.fetchDDMStructure(parentStructureId);
                parentStructureLayoutId = ddmStructure.getDefaultDDMStructureLayoutId();
            }
            ddmForm = this._ddmDataDefinitionConverter.convertDDMFormDataDefinition(ddmForm, parentStructureId, parentStructureLayoutId);
            if (ddmFormLayout != null) {
                ddmFormLayout = this._ddmDataDefinitionConverter.convertDDMFormLayoutDataDefinition(ddmForm, ddmFormLayout);
            }
        }
        this._validateExternalReferenceCode(externalReferenceCode, 0L, groupId, classNameId);
        this._validate(groupId, parentStructureId, classNameId, structureKey, nameMap, ddmForm);
        DDMStructure structure = this._addStructure(externalReferenceCode, user, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, storageType, type, serviceContext);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getModelPermissions());
        }
        DDMStructureVersion structureVersion = this._addStructureVersion(user, structure, "1.0", serviceContext);
        if (ddmFormLayout != null) {
            DDMStructureLayout structureLayout = this._ddmStructureLayoutLocalService.addStructureLayout(userId, groupId, structureVersion.getStructureVersionId(), ddmFormLayout, serviceContext);
            structureLayout.setClassNameId(structure.getClassNameId());
            structureLayout.setStructureLayoutKey(structure.getStructureKey());
            this._ddmStructureLayoutLocalService.updateDDMStructureLayout(structureLayout);
        }
        this._addDataProviderInstanceLinks(groupId, structure.getStructureId(), ddmForm);
        return structure;
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure addStructure(String externalReferenceCode, long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, String storageType, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        this._validateExternalReferenceCode(externalReferenceCode, 0L, groupId, classNameId);
        DDMStructure structure = this.ddmStructurePersistence.create(this.counterLocalService.increment());
        structure.setUuid(serviceContext.getUuid());
        structure.setExternalReferenceCode(externalReferenceCode);
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setCreateDate(new Date());
        structure.setModifiedDate(new Date());
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setVersion("1.0");
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        structure.setStorageType(storageType);
        structure.setType(0);
        structure = (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
        this._addStructureVersion(user, structure, "1.0", serviceContext);
        return structure;
    }

    public void addStructureResources(DDMStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        String resourceName = this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this._resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), resourceName, structure.getStructureId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(DDMStructure structure, ModelPermissions modelPermissions) throws PortalException {
        String resourceName = this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this._resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), resourceName, structure.getStructureId(), modelPermissions);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure copyStructure(long userId, long sourceStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        DDMStructure sourceStructure = this.ddmStructurePersistence.findByPrimaryKey(sourceStructureId);
        String structureKey = String.valueOf(this.counterLocalService.increment());
        this._validate(sourceStructure.getGroupId(), sourceStructure.getParentStructureId(), sourceStructure.getClassNameId(), structureKey, nameMap, sourceStructure.getDDMForm());
        DDMStructure targetStructure = this._addStructure(null, user, sourceStructure.getGroupId(), sourceStructure.getParentStructureId(), sourceStructure.getClassNameId(), structureKey, nameMap, descriptionMap, sourceStructure.getDDMForm(), sourceStructure.getStorageType(), sourceStructure.getType(), serviceContext);
        this._resourceLocalService.copyModelResources(sourceStructure.getCompanyId(), this._ddmPermissionSupport.getStructureModelResourceName(sourceStructure.getClassName()), sourceStructure.getPrimaryKey(), targetStructure.getPrimaryKey());
        DDMStructureVersion structureVersion = this._addStructureVersion(user, targetStructure, "1.0", serviceContext);
        if (sourceStructure.getDDMFormLayout() != null) {
            this._ddmStructureLayoutLocalService.addStructureLayout(userId, sourceStructure.getGroupId(), targetStructure.getClassNameId(), targetStructure.getStructureKey(), structureVersion.getStructureVersionId(), sourceStructure.getDDMFormLayout(), serviceContext);
        }
        this._addDataProviderInstanceLinks(sourceStructure.getGroupId(), targetStructure.getStructureId(), sourceStructure.getDDMForm());
        return targetStructure;
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure copyStructure(long userId, long sourceStructureId, ServiceContext serviceContext) throws PortalException {
        DDMStructure sourceStructure = this.ddmStructurePersistence.findByPrimaryKey(sourceStructureId);
        return this.copyStructure(userId, sourceStructureId, sourceStructure.getNameMap(), sourceStructure.getDescriptionMap(), serviceContext);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public DDMStructure deleteStructure(DDMStructure structure) throws PortalException {
        if (!GroupThreadLocal.isDeleteInProcess()) {
            int count = this._ddmStructureLinkPersistence.countByStructureId(structure.getStructureId());
            if (count > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureReferencedByStructureLinks(structure.getStructureId());
            }
            count = this.ddmStructurePersistence.countByParentStructureId(structure.getStructureId());
            if (count > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureThatHasChild(structure.getStructureId());
            }
            count = this._ddmTemplatePersistence.countByClassPK(structure.getStructureId());
            if (count > 0) {
                throw new RequiredStructureException.MustNotDeleteStructureReferencedByTemplates(structure.getStructureId());
            }
        }
        this.ddmStructurePersistence.remove((BaseModel)structure);
        this._ddmDataProviderInstanceLinkPersistence.removeByStructureId(structure.getStructureId());
        this._ddmStructureLinkPersistence.removeByStructureId(structure.getStructureId());
        List structureVersions = this._ddmStructureVersionLocalService.getStructureVersions(structure.getStructureId());
        for (DDMStructureVersion structureVersion : structureVersions) {
            block7: {
                try {
                    this._ddmStructureLayoutPersistence.removeByStructureVersionId(structureVersion.getStructureVersionId());
                }
                catch (NoSuchStructureLayoutException noSuchStructureLayoutException) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Throwable)noSuchStructureLayoutException);
                }
            }
            this._ddmStructureVersionPersistence.remove((BaseModel)structureVersion);
        }
        String resourceName = this._ddmPermissionSupport.getStructureModelResourceName(structure.getClassName());
        this._resourceLocalService.deleteResource(structure.getCompanyId(), resourceName, 4, structure.getStructureId());
        return structure;
    }

    public void deleteStructure(long structureId) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this._getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByGroupId(groupId);
        this._deleteStructures(structures);
    }

    public void deleteStructures(long groupId, long classNameId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByG_C(groupId, classNameId);
        this._deleteStructures(structures);
    }

    public DDMStructure fetchStructure(long structureId) {
        return this.ddmStructurePersistence.fetchByPrimaryKey(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) {
        structureKey = this._getStructureKey(structureKey);
        return this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this._getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            return null;
        }
        for (long ancestorSiteGroupId : this._getAncestorSiteAndDepotGroupIds(groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(ancestorSiteGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    public DDMStructure fetchStructureByExternalReferenceCode(String externalReferenceCode, long groupId, long classNameId) {
        return this.ddmStructurePersistence.fetchByERC_G_C(externalReferenceCode, groupId, classNameId);
    }

    public DDMStructure fetchStructureByUuidAndGroupId(String uuid, long groupId, boolean includeAncestorStructures) {
        DDMStructure structure = this.ddmStructurePersistence.fetchByUUID_G(uuid, groupId);
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            return null;
        }
        for (long ancestorSiteGroupId : this._getAncestorSiteAndDepotGroupIds(groupId)) {
            structure = this.ddmStructurePersistence.fetchByUUID_G(uuid, ancestorSiteGroupId);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    public List<DDMStructure> getChildrenStructures(long parentStructureId) {
        return this.ddmStructurePersistence.findByParentStructureId(parentStructureId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, -1, -1, orderByComparator);
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this._getStructureKey(structureKey);
        return this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this._getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey);
        }
        for (long curGroupId : this._getAncestorSiteAndDepotGroupIds(groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(curGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey + " in the ancestor groups");
    }

    public List<DDMStructure> getStructure(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public DDMStructure getStructureByExternalReferenceCode(String externalReferenceCode, long groupId, long classNameId) throws PortalException {
        return this.ddmStructurePersistence.findByERC_G_C(externalReferenceCode, groupId, classNameId);
    }

    @Transactional(enabled=false)
    public DDMForm getStructureDDMForm(DDMStructure structure) throws PortalException {
        return this._deserializeJSONDDMForm(structure.getDefinition());
    }

    public List<DDMStructure> getStructures() {
        return this.ddmStructurePersistence.findAll();
    }

    public List<DDMStructure> getStructures(long groupId) {
        return this.ddmStructurePersistence.findByGroupId(groupId);
    }

    public List<DDMStructure> getStructures(long groupId, int start, int end) {
        return this.ddmStructurePersistence.findByGroupId(groupId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.getStructures(companyId, groupIds, classNameId, "", -1, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        Table tempDDMStructureTable = DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{DDMStructureTable.INSTANCE.structureId}).from((Table)DDMStructureTable.INSTANCE).where(this._getPredicate(companyId, groupIds, classNameId, keywords)).as("tempDDMStructure", (Table)DDMStructureTable.INSTANCE);
        return (List)this.ddmStructurePersistence.dslQuery(DSLQueryFactoryUtil.select((Table)DDMStructureTable.INSTANCE).from(tempDDMStructureTable).innerJoinON((Table)DDMStructureTable.INSTANCE, DDMStructureTable.INSTANCE.structureId.eq((Expression)tempDDMStructureTable.getColumn("structureId", Long.class))).orderBy((Table)DDMStructureTable.INSTANCE, orderByComparator).limit(start, end));
    }

    public List<DDMStructure> getStructures(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public List<DDMStructure> getStructures(long[] groupIds) {
        return this.ddmStructurePersistence.findByGroupId(groupIds);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, -1, -1, orderByComparator);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, String name, String description, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C_N_D(groupIds, classNameId, name, description, start, end, orderByComparator);
    }

    public int getStructuresCount(long groupId) {
        return this.ddmStructurePersistence.countByGroupId(groupId);
    }

    public int getStructuresCount(long groupId, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupId, classNameId);
    }

    public int getStructuresCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        return this.ddmStructurePersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.countDistinct((Expression)DDMStructureTable.INSTANCE.structureId).from((Table)DDMStructureTable.INSTANCE).where(this._getPredicate(companyId, groupIds, classNameId, keywords)));
    }

    public int getStructuresCount(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupIds, classNameId);
    }

    public boolean hasStructure(long groupId, long classNameId, String structureKey) {
        int count = this.ddmStructurePersistence.countByG_C_S(groupId, classNameId, structureKey = this._getStructureKey(structureKey));
        return count != 0;
    }

    public String prepareLocalizedDefinitionForImport(DDMStructure structure, Locale defaultImportLocale) throws PortalException {
        DDMForm ddmForm = this._ddm.updateDDMFormDefaultLocale(structure.getDDMForm(), defaultImportLocale);
        return this._serializeJSONDDMForm(ddmForm);
    }

    public void revertStructure(long userId, long structureId, String version, ServiceContext serviceContext) throws PortalException {
        DDMStructureVersion structureVersion = this._ddmStructureVersionLocalService.getStructureVersion(structureId, version);
        if (!structureVersion.isApproved()) {
            throw new InvalidStructureVersionException("Unable to revert from an unapproved file version");
        }
        DDMStructure structure = structureVersion.getStructure();
        serviceContext.setAttribute("majorVersion", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        serviceContext.setCommand("revert");
        this.ddmStructureLocalService.updateStructure(userId, structure.getGroupId(), structureVersion.getParentStructureId(), structure.getClassNameId(), structure.getStructureKey(), structureVersion.getNameMap(), structureVersion.getDescriptionMap(), structureVersion.getDDMForm(), structureVersion.getDDMFormLayout(), serviceContext);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, long classPK, String keywords, int start, int end, OrderByComparator<DDMStructure> orderByComparator) throws PortalException {
        SearchContext searchContext = DDMSearchUtil.buildStructureSearchContext(this._ddmPermissionSupport, companyId, groupIds, classNameId, classPK, keywords, keywords, "", null, -1, start, end, orderByComparator);
        return DDMSearchUtil.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        SearchContext searchContext = DDMSearchUtil.buildStructureSearchContext(this._ddmPermissionSupport, companyId, groupIds, classNameId, null, keywords, keywords, "", null, status, start, end, orderByComparator);
        return DDMSearchUtil.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        SearchContext searchContext = DDMSearchUtil.buildStructureSearchContext(this._ddmPermissionSupport, companyId, groupIds, classNameId, null, name, description, storageType, type, status, start, end, orderByComparator);
        return DDMSearchUtil.doSearch(searchContext, DDMStructure.class, arg_0 -> ((DDMStructurePersistence)this.ddmStructurePersistence).findByPrimaryKey(arg_0));
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, long classPK, String keywords) throws PortalException {
        SearchContext searchContext = DDMSearchUtil.buildStructureSearchContext(this._ddmPermissionSupport, companyId, groupIds, classNameId, classPK, keywords, keywords, "", null, -1, -1, -1, null);
        return DDMSearchUtil.doSearchCount(searchContext, DDMStructure.class);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        SearchContext searchContext = DDMSearchUtil.buildStructureSearchContext(this._ddmPermissionSupport, companyId, groupIds, classNameId, null, keywords, keywords, "", null, status, -1, -1, null);
        return DDMSearchUtil.doSearchCount(searchContext, DDMStructure.class);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator) {
        SearchContext searchContext = DDMSearchUtil.buildStructureSearchContext(this._ddmPermissionSupport, companyId, groupIds, classNameId, null, name, description, storageType, type, status, -1, -1, null);
        return DDMSearchUtil.doSearchCount(searchContext, DDMStructure.class);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long structureId, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this._updateStructure(userId, structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        structureKey = this._getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        return this._updateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this._updateStructure(userId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext, structure);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructure updateStructure(String externalReferenceCode, long userId, long structureId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        this._validateExternalReferenceCode(externalReferenceCode, structureId, groupId, classNameId);
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        structure.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        structure.setUserId(userId);
        structure.setParentStructureId(parentStructureId);
        if (Validator.isNotNull((String)structureKey)) {
            structureKey = StringUtil.toUpperCase((String)structureKey.trim());
            this._validateStructureKey(structureId, structure.getGroupId(), structure.getClassNameId(), structureKey);
            structure.setStructureKey(structureKey);
        }
        DDMStructureVersion latestStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(structure.getStructureId());
        structure.setVersion(latestStructureVersion.getVersion());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setModifiedDate(new Date());
        structure.setNameMap(nameMap, LocaleUtil.fromLanguageId((String)structure.getDefaultLanguageId()));
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        structure = (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
        this._reindexStructure(structure, serviceContext);
        return structure;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DDMStructureIndexer.class, (String)"ddm.structure.indexer.class.name");
    }

    private void _addDataProviderInstanceLinks(long groupId, long structureId, DDMForm ddmForm) {
        Set<Long> dataProviderInstanceIds = this._getDataProviderInstanceIds(groupId, ddmForm);
        for (Long dataProviderInstanceId : dataProviderInstanceIds) {
            this._ddmDataProviderInstanceLinkLocalService.addDataProviderInstanceLink(dataProviderInstanceId.longValue(), structureId);
        }
    }

    private DDMStructure _addStructure(String externalReferenceCode, User user, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.create(this.counterLocalService.increment());
        structure.setUuid(serviceContext.getUuid());
        structure.setExternalReferenceCode(externalReferenceCode);
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setVersionUserId(user.getUserId());
        structure.setVersionUserName(user.getFullName());
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setVersion("1.0");
        structure.setNameMap(nameMap, ddmForm.getDefaultLocale());
        structure.setDescriptionMap(descriptionMap, ddmForm.getDefaultLocale());
        structure.setDefinition(this._serializeJSONDDMForm(ddmForm));
        structure.setStorageType(storageType);
        structure.setType(type);
        return (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
    }

    private DDMStructureVersion _addStructureVersion(User user, DDMStructure structure, String version, ServiceContext serviceContext) {
        DDMStructureVersion structureVersion = this._ddmStructureVersionPersistence.create(this.counterLocalService.increment());
        structureVersion.setGroupId(structure.getGroupId());
        structureVersion.setCompanyId(structure.getCompanyId());
        structureVersion.setUserId(user.getUserId());
        structureVersion.setUserName(user.getFullName());
        structureVersion.setCreateDate(structure.getModifiedDate());
        structureVersion.setStructureId(structure.getStructureId());
        structureVersion.setVersion(version);
        structureVersion.setParentStructureId(structure.getParentStructureId());
        structureVersion.setName(structure.getName());
        structureVersion.setDescription(structure.getDescription());
        structureVersion.setDefinition(structure.getDefinition());
        structureVersion.setStorageType(structure.getStorageType());
        structureVersion.setType(structure.getType());
        structureVersion.setStatus(GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0));
        structureVersion.setStatusByUserId(user.getUserId());
        structureVersion.setStatusByUserName(user.getFullName());
        structureVersion.setStatusDate(structure.getModifiedDate());
        return (DDMStructureVersion)this._ddmStructureVersionPersistence.update((BaseModel)structureVersion);
    }

    private Set<Long> _deleteStructures(List<DDMStructure> structures) throws PortalException {
        if (ListUtil.isEmpty(structures)) {
            return Collections.emptySet();
        }
        HashSet<Long> deletedStructureIds = new HashSet<Long>();
        for (DDMStructure structure : structures) {
            if (deletedStructureIds.contains(structure.getStructureId())) continue;
            if (!GroupThreadLocal.isDeleteInProcess()) {
                List childDDMStructures = this.ddmStructurePersistence.findByParentStructureId(structure.getStructureId());
                deletedStructureIds.addAll(this._deleteStructures(childDDMStructures));
            }
            this.ddmStructureLocalService.deleteStructure(structure);
            deletedStructureIds.add(structure.getStructureId());
        }
        return deletedStructureIds;
    }

    private DDMForm _deserializeDDMForm(String content, DDMFormDeserializer ddmFormDeserializer) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    private DDMForm _deserializeJSONDDMForm(String content) {
        return this._deserializeDDMForm(content, this._jsonDDMFormDeserializer);
    }

    private long[] _getAncestorSiteAndDepotGroupIds(long groupId) {
        SiteConnectedGroupGroupProvider siteConnectedGroupGroupProvider = (SiteConnectedGroupGroupProvider)_siteConnectedGroupGroupProviderSnapshot.get();
        try {
            if (siteConnectedGroupGroupProvider == null) {
                return this._portal.getAncestorSiteGroupIds(groupId);
            }
            return siteConnectedGroupGroupProvider.getAncestorSiteAndDepotGroupIds(groupId, true);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return new long[0];
        }
    }

    private Set<Long> _getDataProviderInstanceIds(long groupId, DDMForm ddmForm) {
        HashSet<Long> dataProviderInstanceIds = new HashSet<Long>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            long[] ddmDataProviderInstanceIds;
            for (long ddmDataProviderInstanceId : ddmDataProviderInstanceIds = this._getDDMDataProviderInstanceIds(ddmFormField.getProperty("ddmDataProviderInstanceId"))) {
                if (ddmDataProviderInstanceId <= 0L) continue;
                dataProviderInstanceIds.add(ddmDataProviderInstanceId);
            }
        }
        for (DDMFormRule ddmFormRule : ddmForm.getDDMFormRules()) {
            Set<Long> ddmFormDataProviderInstanceIds = this._getDataProviderInstanceIds(groupId, ddmFormRule);
            dataProviderInstanceIds.addAll(ddmFormDataProviderInstanceIds);
        }
        return dataProviderInstanceIds;
    }

    private Set<Long> _getDataProviderInstanceIds(long groupId, DDMFormRule ddmFormRule) {
        List actions = ddmFormRule.getActions();
        if (ListUtil.isEmpty((List)actions)) {
            return Collections.emptySet();
        }
        HashSet<Long> dataProviderInstanceIds = new HashSet<Long>();
        for (String action : actions) {
            Matcher matcher = _callFunctionPattern.matcher(action);
            while (matcher.find()) {
                String dataProviderUuid = matcher.group(1);
                DDMDataProviderInstance dataProviderInstance = this._ddmDataProviderInstanceLocalService.fetchDDMDataProviderInstanceByUuidAndGroupId(dataProviderUuid, groupId);
                if (dataProviderInstance == null) continue;
                dataProviderInstanceIds.add(dataProviderInstance.getDataProviderInstanceId());
            }
        }
        return dataProviderInstanceIds;
    }

    private long[] _getDDMDataProviderInstanceIds(JSONArray jsonArray) {
        long[] ddmDataProviderInstanceIds = new long[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            ddmDataProviderInstanceIds[i] = jsonArray.getLong(i);
        }
        return ddmDataProviderInstanceIds;
    }

    private long[] _getDDMDataProviderInstanceIds(Object ddmDataProviderInstanceId) {
        long ddmDataProviderInstanceIdLong;
        block5: {
            if (ddmDataProviderInstanceId instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)ddmDataProviderInstanceId;
                return this._getDDMDataProviderInstanceIds(jsonArray);
            }
            if (ddmDataProviderInstanceId instanceof String) {
                try {
                    JSONArray jsonArray = this._jsonFactory.createJSONArray((String)ddmDataProviderInstanceId);
                    return this._getDDMDataProviderInstanceIds(jsonArray);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Throwable)exception);
                }
            }
        }
        if ((ddmDataProviderInstanceIdLong = GetterUtil.getLong((Object)ddmDataProviderInstanceId)) > 0L) {
            return new long[]{ddmDataProviderInstanceIdLong};
        }
        return GetterUtil.DEFAULT_LONG_VALUES;
    }

    private Set<String> _getDDMFormFieldsNames(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        if (MapUtil.isEmpty((Map)ddmFormFieldsMap)) {
            return Collections.emptySet();
        }
        HashSet<String> ddmFormFieldsNames = new HashSet<String>();
        for (String ddmFormFieldName : ddmFormFieldsMap.keySet()) {
            ddmFormFieldsNames.add(StringUtil.toLowerCase((String)ddmFormFieldName));
        }
        return ddmFormFieldsNames;
    }

    private String _getNextVersion(String version, boolean majorVersion) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    private DDMForm _getParentDDMForm(long parentStructureId) {
        DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
        if (parentStructure == null) {
            return null;
        }
        return parentStructure.getFullHierarchyDDMForm();
    }

    private Predicate _getPredicate(long companyId, long[] groupIds, long classNameId, String keywords) {
        Predicate predicate = DDMStructureTable.INSTANCE.companyId.eq((Object)companyId).and((Expression)DDMStructureTable.INSTANCE.classNameId.eq((Object)classNameId)).and((Expression)DDMStructureTable.INSTANCE.type.eq((Object)0));
        Predicate groupIdsPredicate = null;
        for (long groupId : groupIds) {
            Predicate groupIdPredicate = DDMStructureTable.INSTANCE.groupId.eq((Object)groupId);
            groupIdsPredicate = groupIdsPredicate == null ? groupIdPredicate : groupIdsPredicate.or((Expression)groupIdPredicate);
        }
        if (groupIdsPredicate != null) {
            predicate = predicate.and((Expression)groupIdsPredicate.withParentheses());
        }
        Predicate keywordsPredicate = null;
        for (String keyword : this._customSQL.keywords(keywords, true)) {
            if (keyword == null) continue;
            Predicate keywordPredicate = DSLFunctionFactoryUtil.lower((Expression)DSLFunctionFactoryUtil.castText((Expression)DDMStructureTable.INSTANCE.name)).like(keyword).or((Expression)DSLFunctionFactoryUtil.lower((Expression)DSLFunctionFactoryUtil.castClobText((Expression)DDMStructureTable.INSTANCE.description)).like(keyword));
            keywordsPredicate = keywordsPredicate == null ? keywordPredicate : keywordsPredicate.or((Expression)keywordPredicate);
        }
        if (keywordsPredicate != null) {
            predicate = predicate.and((Expression)keywordsPredicate.withParentheses());
        }
        return predicate;
    }

    private String _getStructureKey(String structureKey) {
        if (structureKey != null) {
            structureKey = structureKey.trim();
            return StringUtil.toUpperCase((String)structureKey);
        }
        return "";
    }

    private List<DDMTemplate> _getStructureTemplates(DDMStructure structure, String type) {
        return this._ddmTemplateLocalService.getTemplates(structure.getGroupId(), this._classNameLocalService.getClassNameId(DDMStructure.class), structure.getStructureId(), type);
    }

    private void _reindexStructure(DDMStructure structure, ServiceContext serviceContext) throws PortalException {
        if (!serviceContext.isIndexingEnabled()) {
            return;
        }
        DDMStructureIndexer ddmStructureIndexer = (DDMStructureIndexer)this._serviceTrackerMap.getService((Object)structure.getClassName());
        if (ddmStructureIndexer == null) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("ddmStructureIndexer", (Object)ddmStructureIndexer);
            message.put("structureId", (Object)structure.getStructureId());
            this._messageBus.sendMessage("liferay/ddm_structure_reindex", message);
            return null;
        });
    }

    private String _serializeJSONDDMForm(DDMForm ddmForm) throws PortalException {
        try {
            DDMFormFieldUtil.sortNestedDDMFormFields((List)ddmForm.getDDMFormFields());
            DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
            DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._jsonDDMFormSerializer.serialize(builder.build());
            return ddmFormSerializerSerializeResponse.getContent();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to serialize dynamic data mapping form to JSON: " + ddmForm), (Throwable)exception);
            }
            throw new StructureDefinitionException((Throwable)exception);
        }
    }

    private void _syncStructureTemplatesFields(DDMStructure structure) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            DDMFormTemplateSynchonizer ddmFormTemplateSynchonizer = new DDMFormTemplateSynchonizer(structure.getDDMForm(), this._jsonDDMFormDeserializer, this._jsonDDMFormSerializer, this._ddmTemplateLocalService);
            List<DDMTemplate> templates = this._getStructureTemplates(structure, "form");
            ddmFormTemplateSynchonizer.setDDMFormTemplates(templates);
            ddmFormTemplateSynchonizer.synchronize();
            return null;
        });
    }

    private void _updateDataProviderInstanceLinks(long groupId, long structureId, DDMForm ddmForm) {
        Set<Long> dataProviderInstanceIds = this._getDataProviderInstanceIds(groupId, ddmForm);
        List dataProviderInstanceLinks = this._ddmDataProviderInstanceLinkLocalService.getDataProviderInstanceLinks(structureId);
        for (DDMDataProviderInstanceLink dataProviderInstanceLink : dataProviderInstanceLinks) {
            if (dataProviderInstanceIds.remove(dataProviderInstanceLink.getDataProviderInstanceId())) continue;
            this._ddmDataProviderInstanceLinkLocalService.deleteDataProviderInstanceLink(dataProviderInstanceLink);
        }
        for (Long dataProviderInstanceId : dataProviderInstanceIds) {
            this._ddmDataProviderInstanceLinkLocalService.addDataProviderInstanceLink(dataProviderInstanceId.longValue(), structureId);
        }
    }

    private DDMStructure _updateStructure(long userId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext, DDMStructure structure) throws PortalException {
        DDMStructureVersion structureVersion;
        User user = this._userLocalService.getUser(userId);
        DDMForm parentDDMForm = this._getParentDDMForm(parentStructureId);
        this._validateParentStructure(structure.getStructureId(), parentStructureId);
        this._validate(nameMap, parentDDMForm, ddmForm);
        structure.setUserId(userId);
        structure.setParentStructureId(parentStructureId);
        DDMStructureVersion latestStructureVersion = this._ddmStructureVersionLocalService.getLatestStructureVersion(structure.getStructureId());
        boolean updateVersion = false;
        if (latestStructureVersion.getStatus() == 2) {
            updateVersion = true;
        }
        boolean majorVersion = GetterUtil.getBoolean((Object)serviceContext.getAttribute("majorVersion"));
        String version = this._getNextVersion(latestStructureVersion.getVersion(), majorVersion);
        if (!updateVersion) {
            structure.setVersionUserId(user.getUserId());
            structure.setVersionUserName(user.getFullName());
            structure.setVersion(version);
        }
        structure.setNameMap(nameMap, ddmForm.getDefaultLocale());
        structure.setDescriptionMap(descriptionMap, ddmForm.getDefaultLocale());
        structure.setDefinition(this._serializeJSONDDMForm(ddmForm));
        if (updateVersion) {
            latestStructureVersion.setDefinition(structure.getDefinition());
            latestStructureVersion.setStatus(GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0));
            latestStructureVersion.setStatusByUserId(user.getUserId());
            latestStructureVersion.setStatusByUserName(user.getFullName());
            latestStructureVersion.setStatusDate(structure.getModifiedDate());
            structureVersion = (DDMStructureVersion)this._ddmStructureVersionPersistence.update((BaseModel)latestStructureVersion);
        } else {
            structureVersion = this._addStructureVersion(user, structure, version, serviceContext);
        }
        serviceContext.getUuid();
        this._ddmStructureLayoutLocalService.addStructureLayout(structureVersion.getUserId(), structureVersion.getGroupId(), structureVersion.getStructureVersionId(), ddmFormLayout, serviceContext);
        if (!structureVersion.isApproved() && structureVersion.isPending()) {
            return structure;
        }
        structure = (DDMStructure)this.ddmStructurePersistence.update((BaseModel)structure);
        this._syncStructureTemplatesFields(structure);
        this._updateDataProviderInstanceLinks(structure.getGroupId(), structure.getStructureId(), ddmForm);
        this._reindexStructure(structure, serviceContext);
        return structure;
    }

    private void _validate(DDMForm ddmForm) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        this._ddmFormValidator.validate(ddmForm);
    }

    private void _validate(DDMForm parentDDMForm, DDMForm ddmForm) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        Set commonDDMFormFieldNames = SetUtil.intersect(this._getDDMFormFieldsNames(parentDDMForm), this._getDDMFormFieldsNames(ddmForm));
        if (!commonDDMFormFieldNames.isEmpty()) {
            throw new StructureDuplicateElementException("Duplicate dynamic data mapping form field names: " + StringUtil.merge((Collection)commonDDMFormFieldNames));
        }
    }

    private void _validate(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, DDMForm ddmForm) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this._getStructureKey(structureKey));
        if (structure != null) {
            StructureDuplicateStructureKeyException structureDuplicateStructureKeyException = new StructureDuplicateStructureKeyException();
            structureDuplicateStructureKeyException.setStructureKey(structure.getStructureKey());
            throw structureDuplicateStructureKeyException;
        }
        this._validate(nameMap, this._getParentDDMForm(parentStructureId), ddmForm);
    }

    private void _validate(Map<Locale, String> nameMap, DDMForm parentDDMForm, DDMForm ddmForm) throws PortalException {
        try {
            if (ExportImportThreadLocal.isImportInProcess()) {
                return;
            }
            this._validate(nameMap, ddmForm.getDefaultLocale());
            this._validate(ddmForm);
            if (parentDDMForm != null) {
                this._validate(parentDDMForm, ddmForm);
            }
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            throw ddmFormValidationException;
        }
        catch (LocaleException localeException) {
            throw localeException;
        }
        catch (StructureDuplicateElementException structureDuplicateElementException) {
            throw structureDuplicateElementException;
        }
        catch (StructureNameException structureNameException) {
            throw structureNameException;
        }
        catch (StructureDefinitionException structureDefinitionException) {
            throw structureDefinitionException;
        }
        catch (Exception exception) {
            throw new StructureDefinitionException((Throwable)exception);
        }
    }

    private void _validate(Map<Locale, String> nameMap, Locale contentDefaultLocale) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        String name = nameMap.get(contentDefaultLocale);
        if (Validator.isNull((String)name)) {
            throw new StructureNameException("Name is null for locale " + contentDefaultLocale.getDisplayName());
        }
        if (!this._language.isAvailableLocale(contentDefaultLocale)) {
            LocaleException localeException = new LocaleException(3, StringBundler.concat((Object[])new Object[]{"The locale ", contentDefaultLocale, " is not available in company ", CompanyThreadLocal.getCompanyId()}));
            localeException.setSourceAvailableLocales(Collections.singleton(contentDefaultLocale));
            localeException.setTargetAvailableLocales((Collection)this._language.getAvailableLocales());
            throw localeException;
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long structureId, long groupId, long classNameId) {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        DDMStructure structure = this.ddmStructurePersistence.fetchByERC_G_C(externalReferenceCode, groupId, classNameId);
        if (structure != null && structure.getStructureId() != structureId) {
            throw new DuplicateDDMStructureExternalReferenceCodeException(StringBundler.concat((Object[])new Object[]{"Duplicate dynamic data mapping structure external ", "reference code \"", externalReferenceCode, "\" for class name ID \"", classNameId, "\" in group \"", groupId, "\""}));
        }
    }

    private void _validateParentStructure(long structureId, long parentStructureId) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        while (parentStructureId != 0L) {
            DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
            if (structureId == parentStructure.getStructureId()) {
                throw new InvalidParentStructureException();
            }
            parentStructureId = parentStructure.getParentStructureId();
        }
    }

    private void _validateStructureKey(long structureId, long groupId, long classNameId, String structureKey) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
        if (structure == null || structure.getStructureId() == structureId) {
            return;
        }
        StructureDuplicateStructureKeyException structureDuplicateStructureKeyException = new StructureDuplicateStructureKeyException();
        structureDuplicateStructureKeyException.setStructureKey(structure.getStructureKey());
        throw structureDuplicateStructureKeyException;
    }
}

