/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.configuration.DDMIndexerConfiguration;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.FieldArray;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.NestedSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortBuilderFactory;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.dynamic.data.mapping.configuration.DDMIndexerConfiguration"}, service={DDMIndexer.class})
public class DDMIndexerImpl
implements DDMIndexer {
    @Reference
    protected Queries queries;
    @Reference
    protected SearchEngineInformation searchEngineInformation;
    @Reference
    protected SortBuilderFactory sortBuilderFactory;
    @Reference
    protected Sorts sorts;
    private static final int _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH = GetterUtil.getInteger((String)PropsUtil.get((String)"index.sortable.text.fields.truncated.length"));
    private static final Log _log = LogFactoryUtil.getLog(DDMIndexerImpl.class);
    @Reference
    private DDM _ddm;
    private volatile DDMIndexerConfiguration _ddmIndexerConfiguration;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private JSONFactory _jsonFactory;

    public void addAttributes(Document document, DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        boolean legacyDDMIndexFieldsEnabled = this.isLegacyDDMIndexFieldsEnabled();
        FieldArray fieldArray = (FieldArray)document.getField("ddmFieldArray");
        if (fieldArray == null && !legacyDDMIndexFieldsEnabled) {
            fieldArray = new FieldArray("ddmFieldArray");
            document.add((Field)fieldArray);
        }
        Set locales = ddmFormValues.getAvailableLocales();
        for (FieldPair fieldPair : this._toFieldPairs(ddmStructure, ddmFormValues)) {
            try {
                DDMFormField ddmFormField = fieldPair._ddmFormField;
                String indexType = ddmFormField.getIndexType();
                String name = null;
                Serializable value = null;
                if (ddmFormField.isLocalizable()) {
                    for (Locale locale : locales) {
                        value = this._getValue(fieldPair._field, ddmFormField, locale);
                        if (value != null || legacyDDMIndexFieldsEnabled) {
                            name = this.encodeName(ddmStructure.getStructureId(), ddmFormField.getFieldReference(), locale, indexType);
                        }
                        if (legacyDDMIndexFieldsEnabled) {
                            this._addToDocument(document, indexType, name, ddmFormField.getType(), value);
                            continue;
                        }
                        if (value == null) continue;
                        fieldArray.addField(this.createField(ddmFormField, indexType, locale, name, value));
                    }
                    continue;
                }
                value = this._getValue(fieldPair._field, ddmFormField, ddmFormValues.getDefaultLocale());
                if (value != null || legacyDDMIndexFieldsEnabled) {
                    name = this.encodeName(ddmStructure.getStructureId(), ddmFormField.getFieldReference(), null, indexType);
                }
                if (legacyDDMIndexFieldsEnabled) {
                    this._addToDocument(document, indexType, name, ddmFormField.getType(), value);
                    continue;
                }
                if (value == null) continue;
                fieldArray.addField(this.createField(ddmFormField, indexType, null, name, value));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Throwable)exception);
            }
        }
    }

    public Sort createDDMStructureFieldSort(DDMStructure ddmStructure, String fieldReference, Locale locale, SortOrder sortOrder) throws PortalException {
        DDMFormField ddmFormField = ddmStructure.getDDMFormFieldByFieldReference(fieldReference);
        if (GetterUtil.getBoolean((Object)ddmFormField.getProperty("localizable"))) {
            if (locale == null) {
                throw new IllegalArgumentException("Locale cannot be null if the dynamic data mapping form field is localizable");
            }
        } else {
            locale = null;
        }
        StringBundler sb = new StringBundler(5);
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            sb.append(this.encodeName(ddmStructure.getStructureId(), fieldReference, locale));
        } else {
            sb.append("ddmFieldArray");
            sb.append(".");
            String indexType = ddmStructure.getFieldPropertyByFieldReference(fieldReference, "indexType");
            sb.append(this.getValueFieldName(indexType, locale));
        }
        sb.append("_");
        String ddmFormFieldType = ddmFormField.getType();
        if (Objects.equals(ddmFormFieldType, "ddm-decimal") || Objects.equals(ddmFormFieldType, "ddm-integer") || Objects.equals(ddmFormFieldType, "ddm-number") || Objects.equals(ddmFormFieldType, "numeric")) {
            sb.append("Number");
        } else {
            sb.append("String");
        }
        FieldSort fieldSort = this.sorts.field(Field.getSortableFieldName((String)sb.toString()), sortOrder);
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            return fieldSort;
        }
        NestedSort nestedSort = this.sorts.nested("ddmFieldArray");
        nestedSort.setFilterQuery((Query)this.queries.term(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"}), (Object)this.encodeName(ddmStructure.getStructureId(), fieldReference, locale)));
        fieldSort.setNestedSort(nestedSort);
        return fieldSort;
    }

    public Sort createDDMStructureFieldSort(String ddmStructureFieldName, Locale locale, SortOrder sortOrder) throws PortalException {
        String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
        long ddmStructureId = GetterUtil.getLong((String)ddmStructureFieldNameParts[2]);
        String fieldReference = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)locale)), (String)"");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(ddmStructureId);
        return this.createDDMStructureFieldSort(ddmStructure, fieldReference, locale, sortOrder);
    }

    public QueryFilter createFieldValueQueryFilter(DDMStructure ddmStructure, String fieldReference, Locale locale, Serializable value) throws Exception {
        String indexType = ddmStructure.getFieldPropertyByFieldReference(fieldReference, "indexType");
        return this.createFieldValueQueryFilter(ddmStructure, this.encodeName(ddmStructure.getStructureId(), fieldReference, locale), value, fieldReference, indexType, locale);
    }

    public QueryFilter createFieldValueQueryFilter(String ddmStructureFieldName, Serializable ddmStructureFieldValue, Locale locale) throws Exception {
        String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)ddmStructureFieldNameParts[2]));
        String fieldReference = StringUtil.replaceLast((String)ddmStructureFieldNameParts[3], (String)"_".concat(LocaleUtil.toLanguageId((Locale)locale)), (String)"");
        return this.createFieldValueQueryFilter(ddmStructure, ddmStructureFieldName, ddmStructureFieldValue, fieldReference, ddmStructureFieldNameParts[1], locale);
    }

    public String encodeName(long ddmStructureId, String fieldReference) {
        return this.encodeName(ddmStructureId, fieldReference, null);
    }

    public String encodeName(long ddmStructureId, String fieldReference, Locale locale) {
        DDMStructure ddmStructure;
        String indexType = "";
        boolean localizable = true;
        if (ddmStructureId > 0L && (ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId)) != null) {
            try {
                indexType = ddmStructure.getFieldPropertyByFieldReference(fieldReference, "indexType");
                localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldPropertyByFieldReference(fieldReference, "localizable"));
            }
            catch (PortalException portalException) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to obtain index type for field ", fieldReference, " and DDM structure ID ", ddmStructureId}), portalException);
            }
        }
        if (localizable) {
            return this.encodeName(ddmStructureId, fieldReference, locale, indexType);
        }
        return this.encodeName(ddmStructureId, fieldReference, null, indexType);
    }

    public String extractIndexableAttributes(DDMStructure ddmStructure, DDMFormValues ddmFormValues, Locale locale) {
        StringBundler sb = new StringBundler();
        this._extractIndexableAttributes(ddmFormValues.getDDMFormFieldValues(), ddmStructure, ddmFormValues.getDefaultLocale(), locale, sb);
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String getValueFieldName(String indexType) {
        return this.getValueFieldName(indexType, null);
    }

    public String getValueFieldName(String indexType, Locale locale) {
        String valueFieldName = "ddmFieldValue";
        if (indexType != null) {
            valueFieldName = valueFieldName.concat(StringUtil.upperCaseFirstLetter((String)indexType));
        }
        if (locale != null) {
            valueFieldName = StringBundler.concat((String[])new String[]{valueFieldName, "_", LocaleUtil.toLanguageId((Locale)locale)});
        }
        return valueFieldName;
    }

    public boolean isLegacyDDMIndexFieldsEnabled() {
        if (Objects.equals(this.searchEngineInformation.getVendorString(), "Solr")) {
            return true;
        }
        return this._ddmIndexerConfiguration.enableLegacyDDMIndexFields();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._ddmIndexerConfiguration = (DDMIndexerConfiguration)ConfigurableUtil.createConfigurable(DDMIndexerConfiguration.class, properties);
    }

    protected Field createField(DDMFormField ddmFormField, String indexType, Locale locale, String name, Serializable value) throws PortalException {
        Field ddmField = new Field("");
        SortedArrayList sortedFields = new SortedArrayList(Comparator.comparing(Field::getName));
        DocumentImpl document = new DocumentImpl();
        String valueFieldName = this.getValueFieldName(indexType, locale);
        this._addToDocument((Document)document, indexType, valueFieldName, (Serializable)((Object)this._getSortableValue(ddmFormField, locale, value)), ddmFormField.getType(), value);
        Map documentFields = document.getFields();
        sortedFields.addAll(documentFields.values());
        sortedFields.add(new Field("ddmFieldName", name));
        sortedFields.add(new Field("ddmValueFieldName", valueFieldName));
        sortedFields.forEach(arg_0 -> ((Field)ddmField).addField(arg_0));
        return ddmField;
    }

    protected QueryFilter createFieldValueQueryFilter(DDMStructure ddmStructure, String ddmStructureFieldName, Serializable ddmStructureFieldValue, String fieldReference, String indexType, Locale locale) throws Exception {
        boolean localizable = false;
        if (ddmStructure.hasFieldByFieldReference(fieldReference)) {
            ddmStructureFieldValue = this._ddm.getIndexedFieldValue(ddmStructureFieldValue, ddmStructure.getFieldPropertyByFieldReference(fieldReference, "type"));
            localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldPropertyByFieldReference(fieldReference, "localizable"));
        }
        if (!localizable) {
            locale = null;
        }
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        if (this.isLegacyDDMIndexFieldsEnabled()) {
            this._addFieldValueRequiredTerm((BooleanQuery)booleanQuery, ddmStructureFieldName, ddmStructureFieldValue);
            return new QueryFilter((com.liferay.portal.kernel.search.Query)booleanQuery);
        }
        booleanQuery.addRequiredTerm(StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", "ddmFieldName"}), ddmStructureFieldName);
        this._addFieldValueRequiredTerm((BooleanQuery)booleanQuery, StringBundler.concat((String[])new String[]{"ddmFieldArray", ".", this.getValueFieldName(indexType, locale)}), ddmStructureFieldValue);
        return new QueryFilter((com.liferay.portal.kernel.search.Query)new NestedQuery("ddmFieldArray", (com.liferay.portal.kernel.search.Query)booleanQuery));
    }

    protected String encodeName(long ddmStructureId, String fieldReference, Locale locale, String indexType) {
        StringBundler sb = new StringBundler(8);
        sb.append("ddm__");
        if (Validator.isNotNull((String)indexType)) {
            sb.append(indexType);
            sb.append("__");
        }
        sb.append(ddmStructureId);
        sb.append("__");
        sb.append(fieldReference);
        if (locale != null) {
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
        } else if (this.isLegacyDDMIndexFieldsEnabled() && StringUtil.equals((String)fieldReference, (String)"date")) {
            sb.append("_");
        }
        return sb.toString();
    }

    private void _addField(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, long ddmStructureId, Locale defaultLocale, Map<String, FieldPair> fieldPairs) throws PortalException {
        if (ddmFormField == null || ddmFormField.isTransient() || ddmFormFieldValue.getValue() == null) {
            return;
        }
        String indexType = ddmFormField.getIndexType();
        if (Validator.isNull((String)indexType) || indexType.equals("none")) {
            return;
        }
        com.liferay.dynamic.data.mapping.storage.Field field = this._createField(ddmFormField, ddmFormFieldValuesMap, ddmFormFieldValue, ddmStructureId, defaultLocale);
        FieldPair fieldPair = fieldPairs.get(field.getName());
        if (fieldPair == null) {
            fieldPairs.put(field.getName(), new FieldPair(ddmFormField, field));
            return;
        }
        fieldPair._mergeField(field);
    }

    private void _addFields(DDMForm ddmForm, DDMFormFieldValue ddmFormFieldValue, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, long ddmStructureId, Locale defaultLocale, Map<String, FieldPair> fieldPairs) throws PortalException {
        this._addField(ddmForm.getDDMFormField(ddmFormFieldValue.getName(), true), ddmFormFieldValue, ddmFormFieldValuesMap, ddmStructureId, defaultLocale, fieldPairs);
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._addFields(ddmForm, nestedDDMFormFieldValue, ddmFormFieldValuesMap, ddmStructureId, defaultLocale, fieldPairs);
        }
    }

    private void _addFieldValue(StringBundler sb, String type, String valueString) throws Exception {
        if (type.equals("document_library") || type.equals("link_to_layout")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            if (jsonObject != null && jsonObject.has("title")) {
                sb.append(jsonObject.getString("title"));
            }
        } else if (type.equals("image")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            if (jsonObject == null) {
                return;
            }
            if (jsonObject.has("description") && Validator.isNotNull((String)jsonObject.getString("description"))) {
                sb.append(jsonObject.getString("description"));
            } else if (jsonObject.has("alt") && Validator.isNotNull((String)jsonObject.getString("alt"))) {
                sb.append(jsonObject.getString("alt"));
            } else if (jsonObject.has("title")) {
                sb.append(jsonObject.getString("title"));
            }
        } else if (type.equals("journal_article")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            if (jsonObject == null) {
                return;
            }
            if (jsonObject.has("titleMap")) {
                JSONObject titleMapJSONObject = jsonObject.getJSONObject("titleMap");
                Iterator iterator = titleMapJSONObject.keys();
                while (iterator.hasNext()) {
                    sb.append(titleMapJSONObject.getString((String)iterator.next()));
                    if (!iterator.hasNext()) continue;
                    sb.append(" ");
                }
            } else if (jsonObject.has("title")) {
                sb.append(jsonObject.getString("title"));
            }
        } else if (type.equals("rich_text")) {
            sb.append(this._htmlParser.extractText(valueString));
        } else if (type.equals("checkbox_multiple") || type.equals("select")) {
            JSONArray jsonArray = this._jsonFactory.createJSONArray(valueString);
            sb.append(ArrayUtil.toStringArray((JSONArray)jsonArray));
        } else {
            sb.append(valueString);
        }
    }

    private void _addFieldValueRequiredTerm(BooleanQuery booleanQuery, String fieldName, Serializable fieldValue) {
        if (fieldValue instanceof String[]) {
            String[] fieldValueArray;
            for (String fieldValueString : fieldValueArray = (String[])fieldValue) {
                booleanQuery.addRequiredTerm(fieldName, "\"" + fieldValueString + "\"");
            }
        } else {
            booleanQuery.addRequiredTerm(fieldName, "\"" + String.valueOf(fieldValue) + "\"");
        }
    }

    private void _addToDocument(Document document, String indexType, String name, Serializable sortableValue, String type, Serializable value) throws PortalException {
        if (value != null) {
            if (value instanceof BigDecimal) {
                document.addNumberSortable(name, (BigDecimal)value);
            } else if (value instanceof BigDecimal[]) {
                document.addNumberSortable(name, (BigDecimal[])value);
            } else if (value instanceof Boolean) {
                document.addKeywordSortable(name, (Boolean)value);
            } else if (value instanceof Boolean[]) {
                document.addKeywordSortable(name, (Boolean[])value);
            } else if (value instanceof Date) {
                document.addDateSortable(name, (Date)value);
            } else if (value instanceof Date[]) {
                document.addDateSortable(name, (Date[])value);
            } else if (value instanceof Double) {
                document.addNumberSortable(name, (Double)value);
            } else if (value instanceof Double[]) {
                document.addNumberSortable(name, (Double[])value);
            } else if (value instanceof Integer) {
                document.addNumberSortable(name, (Integer)value);
            } else if (value instanceof Integer[]) {
                document.addNumberSortable(name, (Integer[])value);
            } else if (value instanceof Long) {
                document.addNumberSortable(name, (Long)value);
            } else if (value instanceof Long[]) {
                document.addNumberSortable(name, (Long[])value);
            } else if (value instanceof Float) {
                document.addNumberSortable(name, (Float)value);
            } else if (value instanceof Float[]) {
                document.addNumberSortable(name, (Float[])value);
            } else if (value instanceof Number[]) {
                Number[] numbers = (Number[])value;
                Double[] doubles = new Double[numbers.length];
                for (int i = 0; i < numbers.length; ++i) {
                    doubles[i] = numbers[i].doubleValue();
                }
                document.addNumberSortable(name, doubles);
            } else if (value instanceof Object[]) {
                Object[] valuesString;
                Object[] truncatedValuesString = valuesString = ArrayUtil.toStringArray((Object[])((Object[])value));
                if (type.equals("date") || type.equals("date_time")) {
                    Date[] dateValues = this._getDateValues(type, (String[])valuesString);
                    if (dateValues.length > 0) {
                        document.addDate(name.concat("_date"), dateValues);
                    }
                } else if (type.equals("rich_text")) {
                    ArrayList<String> richTextValues = new ArrayList<String>(valuesString.length);
                    ArrayList<String> truncatedValues = new ArrayList<String>(valuesString.length);
                    for (Object valueString2 : valuesString) {
                        String richTextValue = this._htmlParser.extractText((String)valueString2);
                        richTextValues.add(richTextValue);
                        truncatedValues.add(this._truncate(richTextValue));
                    }
                    valuesString = richTextValues.toArray(new String[0]);
                    truncatedValuesString = truncatedValues.toArray(new String[0]);
                } else if (type.equals("text")) {
                    truncatedValuesString = (String[])TransformUtil.transform((Object[])valuesString, valueString -> this._truncate((String)valueString), String.class);
                }
                if (indexType.equals("keyword")) {
                    document.addKeywordSortable(name, (String[])valuesString);
                    document.addKeyword(this._getSortableFieldName(name), (String[])truncatedValuesString);
                } else {
                    document.addTextSortable(name, (String[])valuesString);
                    document.addText(this._getSortableFieldName(name), (String[])truncatedValuesString);
                }
            } else {
                String sortableValueString = StringUtil.toLowerCase((String)String.valueOf(sortableValue));
                String valueString3 = String.valueOf(value);
                if (type.equals("geolocation")) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString3);
                    double latitude = jsonObject.getDouble("lat", 0.0);
                    double longitude = jsonObject.getDouble("lng", 0.0);
                    document.addGeoLocation(name.concat("_geolocation"), latitude, longitude);
                } else if (type.equals("checkbox_multiple") || type.equals("select")) {
                    document.addKeyword(this._getFieldName(name), this._toStringArray(sortableValue));
                    document.addKeyword(this._getSortableFieldName(name), this._toStringArray(sortableValueString));
                    document.addKeyword(name, this._toStringArray(valueString3));
                } else {
                    if ((type.equals("date") || type.equals("date_time")) && Validator.isNotNull((String)valueString3)) {
                        Date[] dateValues = this._getDateValues(type, new String[]{valueString3});
                        if (dateValues.length > 0) {
                            document.addDate(name.concat("_date"), dateValues);
                        }
                    } else if (type.equals("rich_text")) {
                        valueString3 = this._htmlParser.extractText(valueString3);
                        sortableValueString = this._htmlParser.extractText(sortableValueString);
                    }
                    this._createSortableTextField(document, name, sortableValueString);
                    if (indexType.equals("keyword")) {
                        document.addKeyword(name, valueString3);
                    } else {
                        document.addText(name, valueString3);
                    }
                }
            }
        }
    }

    private void _addToDocument(Document document, String indexType, String name, String type, Serializable value) throws PortalException {
        this._addToDocument(document, indexType, name, value, type, value);
    }

    private com.liferay.dynamic.data.mapping.storage.Field _createField(DDMFormField ddmFormField, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, DDMFormFieldValue ddmFormFieldValue, long ddmStructureId, Locale defaultLocale) throws PortalException {
        com.liferay.dynamic.data.mapping.storage.Field field = new com.liferay.dynamic.data.mapping.storage.Field();
        field.setDDMStructureId(ddmStructureId);
        field.setDefaultLocale(defaultLocale);
        field.setName(ddmFormFieldValue.getName());
        Value value = ddmFormFieldValue.getValue();
        boolean addValueLocales = false;
        if (MapUtil.isEmpty((Map)value.getValues())) {
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            Map predefinedValuesMap = predefinedValue.getValues();
            if (predefinedValuesMap.isEmpty()) {
                LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
                localizedValue.addString(defaultLocale, "");
                ddmFormField.setPredefinedValue(localizedValue);
            }
            value = ddmFormField.getPredefinedValue();
            addValueLocales = true;
        }
        if (!value.isLocalized()) {
            field.addValue(defaultLocale, FieldConstants.getSerializable((Locale)defaultLocale, (Locale)LocaleUtil.ROOT, (String)ddmFormField.getDataType(), (String)value.getString(LocaleUtil.ROOT)));
            return field;
        }
        Set<Locale> availableLocales = this._getAvailableLocales(ddmFormFieldValuesMap, ddmFormField.getName());
        if (addValueLocales) {
            availableLocales.addAll(value.getAvailableLocales());
        }
        for (Locale availableLocale : availableLocales) {
            field.addValue(availableLocale, FieldConstants.getSerializable((Locale)availableLocale, (Locale)availableLocale, (String)ddmFormField.getDataType(), (String)value.getString(availableLocale)));
        }
        return field;
    }

    private void _createSortableTextField(Document document, String name, String sortableValueString) {
        if (Validator.isNull((String)sortableValueString)) {
            return;
        }
        document.addKeyword(this._getSortableFieldName(name), this._truncate(sortableValueString));
    }

    private void _extractIndexableAttribute(DDMFormField ddmFormField, Locale defaultLocale, String indexType, Locale locale, StringBundler sb, Value value) throws Exception {
        if (Validator.isNull((String)indexType) || indexType.equals("none") || value == null) {
            return;
        }
        Serializable serializable = FieldConstants.getSerializable((Locale)defaultLocale, (Locale)locale, (String)ddmFormField.getDataType(), (String)value.getString(locale));
        if (serializable == null || Validator.isBlank((String)String.valueOf(serializable))) {
            return;
        }
        if (serializable instanceof Boolean || serializable instanceof Number) {
            sb.append((Object)serializable);
        } else if (serializable instanceof Date) {
            Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
            sb.append(dateFormat.format(serializable));
        } else {
            this._addFieldValue(sb, ddmFormField.getType(), this._getSortableValue(ddmFormField, locale, serializable));
        }
        sb.append(" ");
    }

    private void _extractIndexableAttributes(List<DDMFormFieldValue> ddmFormFieldValues, DDMStructure ddmStructure, Locale defaultLocale, Locale locale, StringBundler sb) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            block5: {
                DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                if (ddmFormField == null) continue;
                try {
                    Locale ddmFormFieldLocale = locale;
                    if (!ddmFormField.isLocalizable()) {
                        ddmFormFieldLocale = LocaleUtil.ROOT;
                    }
                    this._extractIndexableAttribute(ddmFormField, defaultLocale, ddmFormField.getIndexType(), ddmFormFieldLocale, sb, ddmFormFieldValue.getValue());
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to index ", ddmFormField.getName(), " because it was deleted from the dynamic data ", "mapping structure ID", ddmStructure.getStructureId()}));
                }
            }
            if (!ListUtil.isNotEmpty((List)ddmFormFieldValue.getNestedDDMFormFieldValues())) continue;
            this._extractIndexableAttributes(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmStructure, defaultLocale, locale, sb);
        }
    }

    private Set<Locale> _getAvailableLocales(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, String name) {
        Value value;
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(name);
        if (ddmFormFieldValues == null) {
            return availableLocales;
        }
        ArrayList matchedDDMFormFieldValues = new ArrayList();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            value = ddmFormFieldValue.getValue();
            if (value == null) continue;
            availableLocales.addAll(value.getAvailableLocales());
            ddmFormFieldValue.populateNestedDDMFormFieldValues(name, matchedDDMFormFieldValues);
        }
        for (DDMFormFieldValue ddmFormFieldValue : matchedDDMFormFieldValues) {
            value = ddmFormFieldValue.getValue();
            if (value == null) continue;
            availableLocales.addAll(value.getAvailableLocales());
        }
        return availableLocales;
    }

    private Date[] _getDateValues(String type, String[] values) {
        String pattern = "yyyy-MM-dd";
        if (type.equals("date_time")) {
            pattern = "yyyy-MM-dd hh:mm";
        }
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)pattern);
        return (Date[])TransformUtil.transform((Object[])values, value -> {
            if (Validator.isNull((String)value)) {
                return null;
            }
            try {
                return dateFormat.parse((String)value);
            }
            catch (ParseException parseException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)parseException);
                }
                return null;
            }
        }, Date.class);
    }

    private String _getFieldName(String name) {
        return name + "_String";
    }

    private String _getSortableFieldName(String name) {
        return Field.getSortableFieldName((String)this._getFieldName(name));
    }

    private String _getSortableValue(DDMFormField ddmFormField, Locale locale, Serializable value) {
        if (value == null) {
            return null;
        }
        String sortableValue = String.valueOf(value);
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty("options");
        Map options = ddmFormFieldOptions.getOptions();
        if (MapUtil.isEmpty((Map)options)) {
            return sortableValue;
        }
        try {
            JSONArray jsonArray = this._jsonFactory.createJSONArray();
            JSONArray sortableValueJSONArray = this._jsonFactory.createJSONArray(sortableValue);
            for (int i = 0; i < sortableValueJSONArray.length(); ++i) {
                LocalizedValue localizedValue = (LocalizedValue)options.get(sortableValueJSONArray.getString(i));
                if (localizedValue == null) {
                    jsonArray.put(sortableValueJSONArray.getString(i));
                    continue;
                }
                jsonArray.put(localizedValue.getString(locale));
            }
            return jsonArray.toString();
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            for (Map.Entry entry : options.entrySet()) {
                LocalizedValue localizedValue = (LocalizedValue)entry.getValue();
                sortableValue = StringUtil.replace((String)sortableValue, (String)((String)entry.getKey()), (String)localizedValue.getString(locale));
            }
            return sortableValue;
        }
    }

    private Serializable _getValue(com.liferay.dynamic.data.mapping.storage.Field field, DDMFormField ddmFormField, Locale locale) {
        List values = field.getValues(locale);
        if (values.isEmpty()) {
            return null;
        }
        try {
            if (values.size() > 1 || ddmFormField.isRepeatable()) {
                return FieldConstants.getSerializable((String)ddmFormField.getDataType(), (List)values);
            }
            return (Serializable)values.get(0);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to extract field value", (Throwable)exception);
            return null;
        }
    }

    private Collection<FieldPair> _toFieldPairs(DDMStructure ddmStructure, DDMFormValues ddmFormValues) {
        try {
            DDMForm ddmForm = ddmStructure.getFullHierarchyDDMForm(false);
            List ddmFormFieldValues = DDMFormValuesConverterUtil.getDDMFormFieldValues((Collection)ddmForm.getDDMFormFields(), (Map)ddmFormValues.getDDMFormFieldValuesMap(true));
            HashMap<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap = new HashMap<String, List<DDMFormFieldValue>>();
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                List curDDMFormFieldValues = ddmFormFieldValuesMap.computeIfAbsent(ddmFormFieldValue.getName(), key -> new ArrayList());
                curDDMFormFieldValues.add(ddmFormFieldValue);
                ddmFormFieldValue.populateNestedDDMFormFieldValuesMap(ddmFormFieldValuesMap);
            }
            HashMap<String, FieldPair> fieldPairs = new HashMap<String, FieldPair>();
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                this._addFields(ddmForm, ddmFormFieldValue, ddmFormFieldValuesMap, ddmStructure.getStructureId(), ddmFormValues.getDefaultLocale(), fieldPairs);
            }
            return fieldPairs.values();
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to convert DDMFormValues to Fields", (Throwable)portalException);
            return Collections.emptySet();
        }
    }

    private String[] _toStringArray(Object value) throws PortalException {
        return ArrayUtil.toStringArray((JSONArray)this._jsonFactory.createJSONArray(String.valueOf(value)));
    }

    private String _truncate(String string) {
        if (string.length() > _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH) {
            return string.substring(0, _SORTABLE_TEXT_FIELDS_TRUNCATED_LENGTH);
        }
        return string;
    }

    private static class FieldPair {
        private final DDMFormField _ddmFormField;
        private final com.liferay.dynamic.data.mapping.storage.Field _field;

        private FieldPair(DDMFormField ddmFormField, com.liferay.dynamic.data.mapping.storage.Field field) {
            this._ddmFormField = ddmFormField;
            this._field = field;
        }

        private void _mergeField(com.liferay.dynamic.data.mapping.storage.Field field) {
            for (Locale locale : field.getAvailableLocales()) {
                this._field.addValues(locale, field.getValues(locale));
            }
        }
    }
}

