/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_9_0;

import com.liferay.dynamic.data.mapping.data.provider.settings.DDMDataProviderSettingsProvider;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesSerializeUtil;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMDataProviderInstanceUpgradeProcess
extends UpgradeProcess {
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final ServiceTrackerMap<String, DDMDataProviderSettingsProvider> _serviceTrackerMap;

    public DDMDataProviderInstanceUpgradeProcess(ServiceTrackerMap<String, DDMDataProviderSettingsProvider> ddmDataProviderSettingsProviderServiceTracker, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer) {
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._serviceTrackerMap = ddmDataProviderSettingsProviderServiceTracker;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, dataProviderInstanceId, definition, type_ from DDMDataProviderInstance");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMDataProviderInstance set definition = ? where ctCollectionId = ? and dataProviderInstanceId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setString(1, this._upgradeDataProviderInstanceDefinition(resultSet.getString("definition"), resultSet.getString("type_")));
                preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                preparedStatement2.setLong(3, resultSet.getLong("dataProviderInstanceId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _updateNestedDDMFormFieldValue(DDMFormFieldValue nestedDDMFormFieldValue) {
        Value value = nestedDDMFormFieldValue.getValue();
        Map valuesMap = value.getValues();
        for (Map.Entry valueEntry : valuesMap.entrySet()) {
            String valueString = (String)valueEntry.getValue();
            String[] valueStringParts = valueString.split(";");
            if (valueStringParts.length <= 1) continue;
            String outputPathType = valueStringParts[1];
            String outputPathValue = valueStringParts[0];
            if (outputPathType.equals("List")) {
                outputPathValue = StringBundler.concat((String[])new String[]{"$", "..", outputPathValue});
            }
            valuesMap.put((Locale)valueEntry.getKey(), outputPathValue);
        }
    }

    private String _upgradeDataProviderInstanceDefinition(String dataProviderInstanceDefinition, String type) throws Exception {
        DDMDataProviderSettingsProvider ddmDataProviderSettingsProvider = (DDMDataProviderSettingsProvider)this._serviceTrackerMap.getService((Object)type);
        DDMForm ddmForm = DDMFormFactory.create((Class)ddmDataProviderSettingsProvider.getSettings());
        DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)dataProviderInstanceDefinition, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(false);
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("outputParameters");
        if (ddmFormFieldValues != null) {
            Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(false);
            DDMFormField ddmFormField = (DDMFormField)ddmFormFieldsMap.get("outputParameters");
            Map nestedDDMFormFieldsMap = ddmFormField.getNestedDDMFormFieldsMap();
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                ddmFormFieldValue.setNestedDDMFormFields(TransformUtil.transform((Collection)ddmFormFieldValue.getNestedDDMFormFieldValues(), nestedDDMFormFieldValue -> {
                    String nestedDDMFormFieldValueName = nestedDDMFormFieldValue.getName();
                    DDMFormField nestedDDMFormField = (DDMFormField)nestedDDMFormFieldsMap.get(nestedDDMFormFieldValueName);
                    if (nestedDDMFormField == null) {
                        return null;
                    }
                    if (nestedDDMFormFieldValueName.equals("outputParameterPath")) {
                        this._updateNestedDDMFormFieldValue((DDMFormFieldValue)nestedDDMFormFieldValue);
                    }
                    return nestedDDMFormFieldValue;
                }));
            }
        }
        return DDMFormValuesSerializeUtil.serialize((DDMFormValues)ddmFormValues, (DDMFormValuesSerializer)this._ddmFormValuesSerializer);
    }
}

