/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.index.contributor;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateTable;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersionTable;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.ReindexCacheThreadLocal;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate"}, service={ModelDocumentContributor.class})
public class DDMTemplateModelDocumentContributor
implements ModelDocumentContributor<DDMTemplate> {
    @Reference
    protected DDMTemplateVersionLocalService ddmTemplateVersionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateModelDocumentContributor.class);
    @Reference
    private DDMPermissionSupport _ddmPermissionSupport;
    @Reference
    private Localization _localization;

    public void contribute(Document document, DDMTemplate ddmTemplate) {
        block6: {
            block5: {
                document.addKeyword("classNameId", ddmTemplate.getClassNameId());
                document.addKeyword("classPK", ddmTemplate.getClassPK());
                document.addKeyword("language", ddmTemplate.getLanguage());
                document.addKeyword("mode", ddmTemplate.getMode());
                document.addKeyword("resourceClassNameId", ddmTemplate.getResourceClassNameId());
                try {
                    Integer status = this._getStatus(ddmTemplate);
                    if (status != null) {
                        document.addKeyword("status", status);
                        document.addKeyword("version", ddmTemplate.getVersion());
                    }
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Throwable)portalException);
                }
            }
            try {
                document.addKeyword("resourcePermissionName", this._ddmPermissionSupport.getTemplateModelResourceName(ddmTemplate.getResourceClassNameId()));
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)portalException);
            }
        }
        document.addLocalizedText("description", this._localization.populateLocalizationMap(ddmTemplate.getDescriptionMap(), ddmTemplate.getDefaultLanguageId(), ddmTemplate.getGroupId()));
        document.addLocalizedText("name", this._localization.populateLocalizationMap(ddmTemplate.getNameMap(), ddmTemplate.getDefaultLanguageId(), ddmTemplate.getGroupId()));
        document.addKeyword("type", ddmTemplate.getType());
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = this._localization.getAvailableLanguageIds(content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }

    private Integer _getStatus(DDMTemplate ddmTemplate) throws PortalException {
        Map statuses = (Map)ReindexCacheThreadLocal.getGlobalReindexCache(() -> -1, (String)DDMTemplateModelDocumentContributor.class.getName(), count -> {
            HashMap<Long, Integer> localStatuses = new HashMap<Long, Integer>();
            for (Object[] values : (List)this.ddmTemplateVersionLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DDMTemplateVersionTable.INSTANCE.templateId, DDMTemplateVersionTable.INSTANCE.status}).from((Table)DDMTemplateVersionTable.INSTANCE).innerJoinON((Table)DDMTemplateTable.INSTANCE, DDMTemplateVersionTable.INSTANCE.templateId.eq((Expression)DDMTemplateTable.INSTANCE.templateId).and((Expression)DDMTemplateVersionTable.INSTANCE.version.eq((Expression)DDMTemplateTable.INSTANCE.version))), false)) {
                localStatuses.put((Long)values[0], (Integer)values[1]);
            }
            return localStatuses;
        });
        if (statuses == null) {
            DDMTemplateVersion templateVersion = this.ddmTemplateVersionLocalService.getTemplateVersion(ddmTemplate.getTemplateId(), ddmTemplate.getVersion());
            return templateVersion.getStatus();
        }
        return (Integer)statuses.get(ddmTemplate.getTemplateId());
    }
}

