/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesConverterUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(service={DDMFormValuesToFieldsConverter.class})
public class DDMFormValuesToFieldsConverterImpl
implements DDMFormValuesToFieldsConverter {
    public Fields convert(DDMStructure ddmStructure, DDMFormValues ddmFormValues) throws PortalException {
        DDMForm ddmForm = ddmStructure.getFullHierarchyDDMForm(false);
        List ddmFormFieldValues = DDMFormValuesConverterUtil.addMissingDDMFormFieldValues((Collection)ddmForm.getDDMFormFields(), (Map)ddmFormValues.getDDMFormFieldValuesMap(true));
        HashMap<String, List<DDMFormFieldValue>> ddmFormFieldValuesListMap = new HashMap<String, List<DDMFormFieldValue>>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            List ddmFormFieldValuesList = ddmFormFieldValuesListMap.computeIfAbsent(ddmFormFieldValue.getName(), key -> new ArrayList());
            ddmFormFieldValuesList.add(ddmFormFieldValue);
            ddmFormFieldValue.populateNestedDDMFormFieldValuesMap(ddmFormFieldValuesListMap);
        }
        Fields fields = new Fields();
        StringBundler fieldDisplayNamesSB = new StringBundler(ddmFormFieldValues.size() * 4);
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this._addFields(ddmForm, ddmFormFieldValue, ddmFormFieldValuesListMap, ddmStructure.getStructureId(), ddmFormValues.getDefaultLocale(), fieldDisplayNamesSB, fields);
        }
        if (!ddmFormFieldValues.isEmpty()) {
            fieldDisplayNamesSB.setIndex(fieldDisplayNamesSB.index() - 1);
        }
        fields.put(new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)fieldDisplayNamesSB.toString())));
        return fields;
    }

    private void _addField(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesListMap, long ddmStructureId, Locale defaultLocale, Fields fields) throws PortalException {
        if (ddmFormField == null || ddmFormField.isTransient() || ddmFormFieldValue.getValue() == null) {
            return;
        }
        Field field = this._createField(ddmFormField, ddmFormFieldValuesListMap, ddmFormFieldValue, ddmStructureId, defaultLocale);
        Field existingField = fields.get(field.getName());
        if (existingField == null) {
            fields.put(field);
            return;
        }
        for (Locale availableLocale : field.getAvailableLocales()) {
            existingField.addValues(availableLocale, field.getValues(availableLocale));
        }
    }

    private void _addFields(DDMForm ddmForm, DDMFormFieldValue ddmFormFieldValue, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesListMap, long ddmStructureId, Locale defaultLocale, StringBundler fieldDisplayNamesSB, Fields fields) throws PortalException {
        this._addField(ddmForm.getDDMFormField(ddmFormFieldValue.getName(), true), ddmFormFieldValue, ddmFormFieldValuesListMap, ddmStructureId, defaultLocale, fields);
        fieldDisplayNamesSB.append(ddmFormFieldValue.getName());
        fieldDisplayNamesSB.append("_INSTANCE_");
        fieldDisplayNamesSB.append(ddmFormFieldValue.getInstanceId());
        fieldDisplayNamesSB.append(",");
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._addFields(ddmForm, nestedDDMFormFieldValue, ddmFormFieldValuesListMap, ddmStructureId, defaultLocale, fieldDisplayNamesSB, fields);
        }
    }

    private Field _createField(DDMFormField ddmFormField, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesListMap, DDMFormFieldValue ddmFormFieldValue, long ddmStructureId, Locale defaultLocale) throws PortalException {
        Field field = new Field();
        field.setDDMStructureId(ddmStructureId);
        field.setDefaultLocale(defaultLocale);
        field.setName(ddmFormFieldValue.getName());
        boolean addValueLocales = false;
        Value value = ddmFormFieldValue.getValue();
        if (MapUtil.isEmpty((Map)value.getValues())) {
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            Map predefinedValuesMap = predefinedValue.getValues();
            if (predefinedValuesMap.isEmpty()) {
                LocalizedValue localizedValue = new LocalizedValue(defaultLocale);
                localizedValue.addString(defaultLocale, "");
                ddmFormField.setPredefinedValue(localizedValue);
            }
            value = ddmFormField.getPredefinedValue();
            addValueLocales = true;
        }
        if (!value.isLocalized()) {
            field.addValue(defaultLocale, FieldConstants.getSerializable((Locale)defaultLocale, (Locale)LocaleUtil.ROOT, (String)ddmFormField.getDataType(), (String)value.getString(LocaleUtil.ROOT)));
            return field;
        }
        Set<Locale> availableLocales = this._getAvailableLocales(ddmFormFieldValuesListMap, ddmFormField.getName());
        if (addValueLocales) {
            availableLocales.addAll(value.getAvailableLocales());
        }
        for (Locale availableLocale : availableLocales) {
            field.addValue(availableLocale, FieldConstants.getSerializable((Locale)availableLocale, (Locale)availableLocale, (String)ddmFormField.getDataType(), (String)value.getString(availableLocale)));
        }
        return field;
    }

    private Set<Locale> _getAvailableLocales(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesListMap, String name) {
        Value value;
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        List<DDMFormFieldValue> ddmFormFieldValuesList = ddmFormFieldValuesListMap.get(name);
        if (ddmFormFieldValuesList == null) {
            return availableLocales;
        }
        ArrayList matchedDDMFormFieldValues = new ArrayList();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValuesList) {
            value = ddmFormFieldValue.getValue();
            if (value == null) continue;
            availableLocales.addAll(value.getAvailableLocales());
            ddmFormFieldValue.populateNestedDDMFormFieldValues(name, matchedDDMFormFieldValues);
        }
        for (DDMFormFieldValue ddmFormFieldValue : matchedDDMFormFieldValues) {
            value = ddmFormFieldValue.getValue();
            if (value == null) continue;
            availableLocales.addAll(value.getAvailableLocales());
        }
        return availableLocales;
    }
}

