/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelListener.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private RepositoryLocalService _repositoryLocalService;

    public void onAfterRemove(User user) {
        for (Repository repository : this._repositoryLocalService.getRepositories("com.liferay.dynamic.data.mapping.form.web")) {
            try {
                Folder parentFolder = this._portletFileRepository.getPortletFolder(repository.getRepositoryId(), 0L, "Forms");
                Folder folder = this._dlAppLocalService.getFolder(repository.getRepositoryId(), parentFolder.getFolderId(), user.getScreenName());
                this._dlAppLocalService.updateFolder(folder.getFolderId(), folder.getParentFolderId(), folder.getName() + " " + String.valueOf(user.getUserId()), folder.getDescription(), ServiceContextThreadLocal.getServiceContext());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
    }
}

