/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class StringFieldRenderer
extends BaseFieldRenderer {
    private final JSONFactory _jsonFactory;

    protected StringFieldRenderer(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected String doRender(Field field, Locale locale) throws Exception {
        String fieldType = this._getFieldType(field);
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) continue;
            if (fieldType.equals("select")) {
                valueString = this._handleSelectFieldValue(field, valueString, locale);
            } else if (fieldType.equals("radio")) {
                return this._handleRadioFieldValue(field, String.valueOf(value), locale);
            }
            values.add(valueString);
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) throws Exception {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        String fieldType = this._getFieldType(field);
        String valueString = String.valueOf(value);
        if (fieldType.equals("select")) {
            return this._handleSelectFieldValue(field, valueString, locale);
        }
        if (fieldType.equals("radio")) {
            return this._handleRadioFieldValue(field, valueString, locale);
        }
        return valueString;
    }

    private LocalizedValue _getFieldOptionLabel(Field field, String optionValue) throws Exception {
        DDMStructure ddmStructure = field.getDDMStructure();
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(field.getName());
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        return ddmFormFieldOptions.getOptionLabels(optionValue);
    }

    private String _getFieldType(Field field) throws Exception {
        DDMStructure ddmStructure = field.getDDMStructure();
        return ddmStructure.getFieldType(field.getName());
    }

    private String _handleRadioFieldValue(Field field, String value, Locale locale) throws Exception {
        if (Validator.isNull((String)value)) {
            return "";
        }
        LocalizedValue label = this._getFieldOptionLabel(field, value);
        if (label == null) {
            return value;
        }
        return GetterUtil.getString((String)label.getString(locale));
    }

    private String _handleSelectFieldValue(Field field, String json, Locale locale) throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        if (jsonArray.length() == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(jsonArray.length() * 2);
        for (int i = 0; i < jsonArray.length(); ++i) {
            LocalizedValue localizedValue = this._getFieldOptionLabel(field, jsonArray.getString(i));
            if (localizedValue != null) {
                sb.append(localizedValue.getString(locale));
            } else {
                sb.append(jsonArray.getString(i));
            }
            sb.append(", ");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

