/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_3;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class DataProviderInstanceUpgradeProcess
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public DataProviderInstanceUpgradeProcess(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMDataProviderInstance.definition, ", "DDMDataProviderInstance.dataProviderInstanceId from ", "DDMDataProviderInstance"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMDataProviderInstance set definition = ? where dataProviderInstanceId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String definition = resultSet.getString(1);
                long dataProviderInstanceId = resultSet.getLong(2);
                String newDefinition = this._upgradeDataProviderInstanceDefinition(definition);
                preparedStatement2.setString(1, newDefinition);
                preparedStatement2.setLong(2, dataProviderInstanceId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private String _upgradeDataProviderInstanceDefinition(String definition) throws JSONException {
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldValuesJSONArray = definitionJSONObject.getJSONArray("fieldValues");
        this._upgradeDataProviderInstanceFieldValues(fieldValuesJSONArray);
        return definitionJSONObject.toString();
    }

    private void _upgradeDataProviderInstanceFieldValues(JSONArray fieldValuesJSONArray) {
        JSONObject fieldValueJSONObject = this._jsonFactory.createJSONObject();
        fieldValueJSONObject.put("instanceId", StringUtil.randomString((int)8)).put("name", "timeout").put("value", "1000");
        fieldValuesJSONArray.put(fieldValueJSONObject);
    }
}

