/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.io;

import com.liferay.dynamic.data.mapping.form.field.type.BaseDDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesRegistry;
import com.liferay.dynamic.data.mapping.io.DDMFormFieldTypesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormFieldTypesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormFieldTypesSerializerSerializeResponse;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.form.field.types.serializer.type=json"}, service={DDMFormFieldTypesSerializer.class})
public class DDMFormFieldTypesJSONSerializer
implements DDMFormFieldTypesSerializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormFieldTypesJSONSerializer.class);
    @Reference
    private DDMFormFieldTypeServicesRegistry _ddmFormFieldTypeServicesRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public DDMFormFieldTypesSerializerSerializeResponse serialize(DDMFormFieldTypesSerializerSerializeRequest ddmFormFieldTypesSerializerSerializeRequest) {
        JSONArray jsonArray;
        block3: {
            List ddmFormFieldTypes = ddmFormFieldTypesSerializerSerializeRequest.getDDMFormFieldTypes();
            jsonArray = this._jsonFactory.createJSONArray();
            try {
                for (DDMFormFieldType ddmFormFieldType : ddmFormFieldTypes) {
                    jsonArray.put(this.toJSONObject(ddmFormFieldType));
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)exception);
            }
        }
        DDMFormFieldTypesSerializerSerializeResponse.Builder builder = DDMFormFieldTypesSerializerSerializeResponse.Builder.newBuilder((String)jsonArray.toString());
        return builder.build();
    }

    protected JSONObject toJSONObject(DDMFormFieldType ddmFormFieldType) throws PortalException {
        Map ddmFormFieldTypeProperties;
        JSONObject jsonObject;
        block5: {
            jsonObject = this._jsonFactory.createJSONObject();
            ddmFormFieldTypeProperties = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldTypeProperties(ddmFormFieldType.getName());
            jsonObject.put("group", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.group")).put("icon", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.icon", (String)"icon-ok-circle")).put("javaScriptClass", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.js.class.name", (String)"Liferay.DDM.Renderer.Field")).put("javaScriptModule", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.js.module", (String)"liferay-ddm-form-renderer-field"));
            String description = MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.description");
            String label = MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.label");
            Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
            try {
                ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ddmFormFieldType.getClass());
                if (Validator.isNotNull((String)description)) {
                    jsonObject.put("description", this._language.get(resourceBundle, description));
                }
                if (Validator.isNotNull((String)label)) {
                    jsonObject.put("label", this._language.get(resourceBundle, label));
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Throwable)missingResourceException);
            }
        }
        jsonObject.put("name", ddmFormFieldType.getName()).put("system", MapUtil.getBoolean((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.system"));
        DDMFormFieldRenderer ddmFormFieldRenderer = this._ddmFormFieldTypeServicesRegistry.getDDMFormFieldRenderer(ddmFormFieldType.getName());
        if (ddmFormFieldRenderer instanceof BaseDDMFormFieldRenderer) {
            BaseDDMFormFieldRenderer baseDDMFormFieldRenderer = (BaseDDMFormFieldRenderer)ddmFormFieldRenderer;
            jsonObject.put("templateNamespace", baseDDMFormFieldRenderer.getTemplateNamespace());
        }
        return jsonObject;
    }
}

