/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureVersionException;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureVersionLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.util.comparator.StructureVersionVersionComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructureVersion"}, service={AopService.class})
public class DDMStructureVersionLocalServiceImpl
extends DDMStructureVersionLocalServiceBaseImpl {
    @Reference(target="(ddm.form.deserializer.type=json)")
    private DDMFormDeserializer _jsonDDMFormDeserializer;

    public DDMStructureVersion getLatestStructureVersion(long structureId) throws PortalException {
        List structureVersions = this.ddmStructureVersionPersistence.findByStructureId(structureId);
        if (structureVersions.isEmpty()) {
            throw new NoSuchStructureVersionException("No structure versions found for structure ID " + structureId);
        }
        structureVersions = ListUtil.copy((List)structureVersions);
        Collections.sort(structureVersions, new StructureVersionVersionComparator());
        return (DDMStructureVersion)structureVersions.get(0);
    }

    public DDMStructureVersion getStructureVersion(long structureVersionId) throws PortalException {
        return this.ddmStructureVersionPersistence.findByPrimaryKey(structureVersionId);
    }

    public DDMStructureVersion getStructureVersion(long structureId, String version) throws PortalException {
        return this.ddmStructureVersionPersistence.findByS_V(structureId, version);
    }

    @Transactional(enabled=false)
    public DDMForm getStructureVersionDDMForm(DDMStructureVersion structureVersion) throws PortalException {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)structureVersion.getDefinition());
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._jsonDDMFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    public List<DDMStructureVersion> getStructureVersions(long structureId) {
        return this.ddmStructureVersionPersistence.findByStructureId(structureId);
    }

    public List<DDMStructureVersion> getStructureVersions(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) {
        return this.ddmStructureVersionPersistence.findByStructureId(structureId, start, end, orderByComparator);
    }

    public int getStructureVersionsCount(long structureId) {
        return this.ddmStructureVersionPersistence.countByStructureId(structureId);
    }
}

