/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseTemplateUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeDDMTemplates();
        this._upgradeFragmentEntries();
    }

    protected abstract String getContextVariable();

    protected abstract String getDeprecatedClass();

    protected abstract String getDeprecatedClassReplacement();

    private Pattern _getDeprecatedClassPattern() {
        String deprecatedClass = this.getDeprecatedClass();
        if (deprecatedClass != null) {
            StringBundler sb = new StringBundler(3);
            sb.append("\\w+\\s*\\=\\s*.+");
            sb.append(StringUtil.replace((String)deprecatedClass, (char)'.', (String)"\\."));
            sb.append("\\\"\\)");
            return Pattern.compile(sb.toString());
        }
        return null;
    }

    private String _getVariableName(Matcher matcher) {
        String matcherGroup = matcher.group();
        String variableName = matcherGroup.substring(0, matcherGroup.indexOf("="));
        return variableName.trim();
    }

    private String _replaceDeprecatedClass(Pattern emptyAssignPattern, String template) {
        if (template == null) {
            return "";
        }
        Pattern deprecatedClassPattern = this._getDeprecatedClassPattern();
        if (deprecatedClassPattern != null) {
            Matcher deprecatedClassMatcher = deprecatedClassPattern.matcher(template);
            while (deprecatedClassMatcher.find()) {
                Matcher emptyAssignMatcher;
                template = StringUtil.replace((String)template, (String)deprecatedClassMatcher.group(), (String)this.getDeprecatedClassReplacement());
                if (Validator.isNotNull((String)this.getContextVariable())) {
                    template = StringUtil.replace((String)template, (String)this._getVariableName(deprecatedClassMatcher), (String)this.getContextVariable());
                }
                if (!(emptyAssignMatcher = emptyAssignPattern.matcher(template)).find()) continue;
                template = emptyAssignMatcher.replaceAll("");
            }
        }
        return template;
    }

    private void _upgradeDDMTemplates() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement("select ctCollectionId, templateId, script from DDMTemplate");
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplate set script = ? where ctCollectionId = ? and templateId = ?");){
            try (ResultSet resultSet = selectPreparedStatement.executeQuery();){
                while (resultSet.next()) {
                    if (resultSet.getString("script") == null) continue;
                    updatePreparedStatement.setString(1, this._replaceDeprecatedClass(Pattern.compile("\\<\\#assign\\s*\\/?\\>"), resultSet.getString("script")));
                    updatePreparedStatement.setLong(2, resultSet.getLong("ctCollectionId"));
                    updatePreparedStatement.setLong(3, resultSet.getLong("templateId"));
                    updatePreparedStatement.addBatch();
                }
            }
            updatePreparedStatement.executeBatch();
        }
    }

    private void _upgradeFragmentEntries() throws Exception {
        try (PreparedStatement selectPreparedStatement = this.connection.prepareStatement("select fragmentEntryId, html from FragmentEntry");
             PreparedStatement updatePreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update FragmentEntry set html = ? where fragmentEntryId = ?");
             ResultSet resultSet = selectPreparedStatement.executeQuery();){
            while (resultSet.next()) {
                updatePreparedStatement.setString(1, this._replaceDeprecatedClass(Pattern.compile("\\[\\#assign\\s*\\/?\\]"), resultSet.getString("html")));
                updatePreparedStatement.setLong(2, resultSet.getLong("fragmentEntryId"));
                updatePreparedStatement.addBatch();
            }
            updatePreparedStatement.executeBatch();
        }
    }
}

