/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_8_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpgradeDDMContent
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final JSONFactory _jsonFactory;

    public UpgradeDDMContent(DDMFormDeserializer ddmFormDeserializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(13);
        sb.append("select DDMContent.contentId, DDMContent.data_, ");
        sb.append("DDMStructureVersion.structureVersionId, ");
        sb.append("DDMStructureVersion.definition from DDMContent inner join ");
        sb.append("DDMFormInstanceRecordVersion on DDMContent.contentId = ");
        sb.append("DDMFormInstanceRecordVersion.storageId inner join ");
        sb.append("DDMFormInstanceVersion on ");
        sb.append("DDMFormInstanceRecordVersion.formInstanceId = ");
        sb.append("DDMFormInstanceVersion.formInstanceId and ");
        sb.append("DDMFormInstanceRecordVersion.formInstanceVersion = ");
        sb.append("DDMFormInstanceVersion.version inner join ");
        sb.append("DDMStructureVersion on ");
        sb.append("DDMFormInstanceVersion.structureVersionId = ");
        sb.append("DDMStructureVersion.structureVersionId");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String newData;
                String data;
                DDMForm ddmForm = DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)rs.getString("definition"));
                List ddmFormFields = ddmForm.getDDMFormFields();
                Stream stream = ddmFormFields.stream();
                List<DDMFormField> fieldSetDDMFormFields = stream.filter(ddmFormField -> Objects.equals(ddmFormField.getType(), "fieldset")).collect(Collectors.toList());
                if (fieldSetDDMFormFields.isEmpty() || (data = rs.getString("data_")).equals(newData = this._upgradeDDMContentData(data, fieldSetDDMFormFields))) continue;
                ps2.setString(1, newData);
                ps2.setLong(2, rs.getLong("contentId"));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    private boolean _hasDDMFormField(DDMFormField ddmFormField, JSONArray fieldValuesJSONArray) {
        String ddmFormFieldName = ddmFormField.getName();
        for (JSONObject fieldValueJSONObject : fieldValuesJSONArray) {
            if (!ddmFormFieldName.equals(fieldValueJSONObject.getString("name"))) continue;
            return true;
        }
        return false;
    }

    private String _upgradeDDMContentData(String data, List<DDMFormField> fieldSetDDMFormFields) throws Exception {
        JSONObject dataJSONObject = this._jsonFactory.createJSONObject(data);
        JSONArray fieldValuesJSONArray = dataJSONObject.getJSONArray("fieldValues");
        for (DDMFormField fieldSetDDMFormField : fieldSetDDMFormFields) {
            if (this._hasDDMFormField(fieldSetDDMFormField, fieldValuesJSONArray)) continue;
            Map nestedDDMFormFieldsMap = fieldSetDDMFormField.getNestedDDMFormFieldsMap();
            Set nestedDDMFormFieldNames = nestedDDMFormFieldsMap.keySet();
            JSONArray nestedFieldValuesJSONArray = this._jsonFactory.createJSONArray();
            JSONArray newFieldValuesJSONArray = this._jsonFactory.createJSONArray();
            for (JSONObject fieldValueJSONObject : fieldValuesJSONArray) {
                if (nestedDDMFormFieldNames.contains(fieldValueJSONObject.getString("name"))) {
                    nestedFieldValuesJSONArray.put(fieldValueJSONObject);
                    continue;
                }
                newFieldValuesJSONArray.put(fieldValueJSONObject);
            }
            newFieldValuesJSONArray.put(JSONUtil.put((String)"instanceId", (Object)StringUtil.randomString((int)8)).put("name", fieldSetDDMFormField.getName()).put("nestedFieldValues", nestedFieldValuesJSONArray));
            fieldValuesJSONArray = newFieldValuesJSONArray;
        }
        dataJSONObject.put("fieldValues", fieldValuesJSONArray);
        return dataJSONObject.toString();
    }
}

