/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_0;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesDeserializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesSerializeUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;

public class UpgradeCheckboxFieldToCheckboxMultipleField
extends UpgradeProcess {
    private static final int _SCOPE_FORMS = 2;
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final JSONFactory _jsonFactory;

    public UpgradeCheckboxFieldToCheckboxMultipleField(DDMFormDeserializer ddmFormDeserializer, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("select DDMStructure.definition, DDMStructure.version, ");
        sb.append("DDMStructure.structureId, DDLRecordSet.recordSetId from ");
        sb.append("DDLRecordSet inner join DDMStructure on ");
        sb.append("DDLRecordSet.DDMStructureId = DDMStructure.structureId ");
        sb.append("where DDLRecordSet.scope = ? and DDMStructure.definition ");
        sb.append("like ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureId = ? and version = ?");){
            ps1.setInt(1, 2);
            ps1.setString(2, "%checkbox%");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString(1);
                    String version = rs.getString(2);
                    long structureId = rs.getLong(3);
                    long recordSetId = rs.getLong(4);
                    String newDefinition = this.upgradeRecordSetStructureDefinition(definition);
                    ps2.setString(1, newDefinition);
                    ps2.setLong(2, structureId);
                    ps2.addBatch();
                    ps3.setString(1, newDefinition);
                    ps3.setLong(2, structureId);
                    ps3.setString(3, version);
                    ps3.addBatch();
                    this.updateRecords(DDMFormDeserializeUtil.deserialize((DDMFormDeserializer)this._ddmFormDeserializer, (String)definition), recordSetId);
                }
                ps2.executeBatch();
                ps3.executeBatch();
            }
        }
    }

    protected JSONArray getOptionsJSONArray(JSONObject checkboxFieldJSONObject) {
        JSONArray optionsJSONArray = this._jsonFactory.createJSONArray();
        JSONObject optionJSONObject = this._jsonFactory.createJSONObject();
        optionJSONObject.put("label", checkboxFieldJSONObject.getJSONObject("label")).put("value", checkboxFieldJSONObject.getString("name"));
        optionsJSONArray.put(optionJSONObject);
        return optionsJSONArray;
    }

    protected JSONObject getPredefinedValueJSONObject(JSONObject checkboxFieldJSONObject) {
        JSONObject oldPredefinedValueJSONObject = checkboxFieldJSONObject.getJSONObject("predefinedValue");
        JSONObject newPredefinedValueJSONObject = this._jsonFactory.createJSONObject();
        Iterator iterator = oldPredefinedValueJSONObject.keys();
        while (iterator.hasNext()) {
            String languageKey = (String)iterator.next();
            String predefinedValue = oldPredefinedValueJSONObject.getString(languageKey);
            predefinedValue = Objects.equals(predefinedValue, "true") ? checkboxFieldJSONObject.getString("name") : "";
            newPredefinedValueJSONObject.put(languageKey, predefinedValue);
        }
        return newPredefinedValueJSONObject;
    }

    protected void transformCheckboxDDMFormField(JSONObject checkboxFieldJSONObject) {
        checkboxFieldJSONObject.put("dataType", "string").put("options", this.getOptionsJSONArray(checkboxFieldJSONObject)).put("predefinedValue", this.getPredefinedValueJSONObject(checkboxFieldJSONObject)).put("type", "checkbox_multiple");
    }

    protected void transformCheckboxDDMFormFieldValues(DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new CheckboxDDMFormFieldValueTransformer(this._jsonFactory));
        ddmFormValuesTransformer.transform();
    }

    protected void updateRecords(DDMForm ddmForm, long recordSetId) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select DDLRecordVersion.DDMStorageId, DDMContent.data_ ");
        sb.append("from DDLRecordVersion inner join DDLRecordSet on ");
        sb.append("DDLRecordVersion.recordSetId = DDLRecordSet.recordSetId ");
        sb.append("inner join DDMContent on DDLRecordVersion.DDMStorageId = ");
        sb.append("DDMContent.contentId where DDLRecordSet.recordSetId = ? ");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ? ");){
            ps1.setLong(1, recordSetId);
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String data_ = rs.getString("data_");
                    DDMFormValues ddmFormValues = DDMFormValuesDeserializeUtil.deserialize((String)data_, (DDMForm)ddmForm, (DDMFormValuesDeserializer)this._ddmFormValuesDeserializer);
                    this.transformCheckboxDDMFormFieldValues(ddmFormValues);
                    ps2.setString(1, DDMFormValuesSerializeUtil.serialize((DDMFormValues)ddmFormValues, (DDMFormValuesSerializer)this._ddmFormValuesSerializer));
                    long contentId = rs.getLong("DDMStorageId");
                    ps2.setLong(2, contentId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    protected String upgradeRecordSetStructureDefinition(String definition) throws JSONException {
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldsJSONArray = definitionJSONObject.getJSONArray("fields");
        this.upgradeRecordSetStructureFields(fieldsJSONArray);
        return definitionJSONObject.toString();
    }

    protected void upgradeRecordSetStructureFields(JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONArray nestedFieldsJSONArray;
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            String type = fieldJSONObject.getString("type");
            if (type.equals("checkbox")) {
                this.transformCheckboxDDMFormField(fieldJSONObject);
            }
            if ((nestedFieldsJSONArray = fieldJSONObject.getJSONArray("nestedFields")) == null) continue;
            this.upgradeRecordSetStructureFields(nestedFieldsJSONArray);
        }
    }

    private static class CheckboxDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private JSONFactory _jsonFactory;

        public CheckboxDDMFormFieldValueTransformer(JSONFactory jsonFactory) {
            this._jsonFactory = jsonFactory;
        }

        public String getFieldType() {
            return "checkbox";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONArray valueJSONArray = this._jsonFactory.createJSONArray();
                if (Objects.equals(valueString, "true")) {
                    DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                    valueJSONArray.put(ddmFormField.getName());
                }
                value.addString(locale, valueJSONArray.toString());
            }
        }
    }
}

