/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search.spi.model.query.contributor;

import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord"}, service={ModelPreFilterContributor.class})
public class DDMFormInstanceRecordModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected DDMIndexer ddmIndexer;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordModelPreFilterContributor.class);

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        block6: {
            long formInstanceId;
            int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
            if (status != -1) {
                booleanFilter.addRequiredTerm("status", status);
            }
            if ((formInstanceId = GetterUtil.getLong((Object)searchContext.getAttribute("formInstanceId"))) > 0L) {
                booleanFilter.addRequiredTerm("formInstanceId", formInstanceId);
            }
            String[] languageIds = GetterUtil.getStringValues((Object)searchContext.getAttribute("languageIds"));
            String[] notEmptyFields = GetterUtil.getStringValues((Object)searchContext.getAttribute("notEmptyFields"));
            long structureId = GetterUtil.getLong((Object)searchContext.getAttribute("structureId"));
            if (languageIds.length > 0 && notEmptyFields.length > 0 && structureId > 0L) {
                List locales = Stream.of(languageIds).map(languageId -> LocaleUtil.fromLanguageId((String)languageId)).collect(Collectors.toList());
                Stream.of(notEmptyFields).forEach(notEmptyField -> {
                    BooleanFilter notEmptyFieldBooleanFilter = new BooleanFilter();
                    locales.forEach(locale -> notEmptyFieldBooleanFilter.add((Filter)new ExistsFilter(this.ddmIndexer.encodeName(structureId, notEmptyField, locale)), BooleanClauseOccur.MUST));
                    booleanFilter.add((Filter)notEmptyFieldBooleanFilter, BooleanClauseOccur.MUST_NOT);
                });
            }
            this.addSearchClassTypeIds(booleanFilter, searchContext);
            String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
            Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
            if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
                try {
                    QueryFilter queryFilter = this.ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, searchContext.getLocale());
                    booleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Object)exception, (Throwable)exception);
                }
            }
        }
    }

    protected Filter addSearchClassTypeIds(BooleanFilter contextBooleanFilter, SearchContext searchContext) {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (ArrayUtil.isEmpty((long[])classTypeIds)) {
            return null;
        }
        TermsFilter classTypeIdsTermsFilter = new TermsFilter("classTypeId");
        classTypeIdsTermsFilter.addValues(ArrayUtil.toStringArray((long[])classTypeIds));
        return contextBooleanFilter.add((Filter)classTypeIdsTermsFilter, BooleanClauseOccur.MUST);
    }
}

