/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.model.listener;

import com.liferay.dynamic.data.mapping.internal.petra.executor.DDMFormInstanceReportPortalExecutor;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceReport;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceReportLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DDMFormInstanceRecordVersionModelListener
extends BaseModelListener<DDMFormInstanceRecordVersion> {
    @Reference
    protected DDMFormInstanceReportLocalService ddmFormInstanceReportLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordVersionModelListener.class);
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;
    @Reference
    private DDMFormInstanceReportPortalExecutor _ddmFormInstanceReportPortalExecutor;

    public void onAfterUpdate(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion) throws ModelListenerException {
        block3: {
            try {
                if (ddmFormInstanceRecordVersion.getStatus() != 0) {
                    return;
                }
                this._processFormInstanceReportEvent(ddmFormInstanceRecordVersion, "add");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to update dynamic data mapping form ");
                sb.append("instance report for dynamic data mapping form ");
                sb.append("instance record ");
                sb.append(ddmFormInstanceRecordVersion.getFormInstanceRecordId());
                _log.warn((Object)sb.toString(), (Throwable)exception);
            }
        }
    }

    public void onBeforeUpdate(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion) throws ModelListenerException {
        block3: {
            try {
                if (ddmFormInstanceRecordVersion.getStatus() != 0) {
                    return;
                }
                DDMFormInstanceRecordVersion latestDDMFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.getLatestFormInstanceRecordVersion(ddmFormInstanceRecordVersion.getFormInstanceRecordId(), 0);
                this._processFormInstanceReportEvent(latestDDMFormInstanceRecordVersion, "delete");
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to update dynamic data mapping form ");
                sb.append("instance report for dynamic data mapping form ");
                sb.append("instance record ");
                sb.append(ddmFormInstanceRecordVersion.getFormInstanceRecordId());
                _log.warn((Object)sb.toString(), (Throwable)exception);
            }
        }
    }

    private void _processFormInstanceReportEvent(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, String formInstanceReportEvent) throws PortalException {
        DDMFormInstanceReport ddmFormInstanceReport = this.ddmFormInstanceReportLocalService.getFormInstanceReportByFormInstanceId(ddmFormInstanceRecordVersion.getFormInstanceId());
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this.ddmFormInstanceReportLocalService.processFormInstanceReportEvent(ddmFormInstanceReport.getFormInstanceReportId(), ddmFormInstanceRecordVersion.getFormInstanceRecordVersionId(), formInstanceReportEvent);
            return null;
        });
    }
}

