/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.instance.lifecycle;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import java.util.LinkedList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class DDMCleanUpPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateLinkLocalService _ddmTemplateLinkLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DDMTemplateVersionLocalService _ddmTemplateVersionLocalService;
    @Reference
    private StorageEngine _storageEngine;

    public void portalInstancePreunregistered(Company company) throws Exception {
        Group group = company.getGroup();
        this._deleteDDMTemplates(group);
        LinkedList queue = new LinkedList(this._ddmStructureLocalService.getStructures(company.getGroupId()));
        if (group.hasStagingGroup()) {
            Group stagingGroup = group.getStagingGroup();
            this._deleteDDMTemplates(stagingGroup);
            queue.addAll(this._ddmStructureLocalService.getStructures(stagingGroup.getGroupId()));
        }
        LinkedList<DDMStructure> deque = new LinkedList<DDMStructure>();
        DDMStructure currentDDMStructure = null;
        while ((currentDDMStructure = (DDMStructure)queue.poll()) != null) {
            deque.push(currentDDMStructure);
            queue.addAll(this._ddmStructureLocalService.getChildrenStructures(currentDDMStructure.getStructureId()));
        }
        for (DDMStructure ddmStructure : deque) {
            long structureId = ddmStructure.getStructureId();
            this._ddmStructureLinkLocalService.deleteStructureStructureLinks(structureId);
            for (DDMTemplate ddmTemplate : this._ddmTemplateLocalService.getTemplates(structureId)) {
                this._deleteDDMTemplate(ddmTemplate);
            }
            this._storageEngine.deleteByDDMStructure(ddmStructure.getStructureId());
            this._ddmStructureLocalService.deleteStructure(ddmStructure);
        }
    }

    private void _deleteDDMTemplate(DDMTemplate ddmTemplate) throws Exception {
        this._ddmTemplateVersionLocalService.deleteTemplateVersions(ddmTemplate.getTemplateId());
        this._ddmTemplateLinkLocalService.deleteTemplateLinks(ddmTemplate.getTemplateId());
        this._ddmTemplateLocalService.deleteTemplate(ddmTemplate);
    }

    private void _deleteDDMTemplates(Group group) throws Exception {
        for (DDMTemplate ddmTemplate : this._ddmTemplateLocalService.getTemplatesByGroupId(group.getGroupId())) {
            this._deleteDDMTemplate(ddmTemplate);
        }
    }
}

