/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_8;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpgradeDDMFormDocumentLibraryFields
extends UpgradeProcess {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final JSONFactory _jsonFactory;

    public UpgradeDDMFormDocumentLibraryFields(DDMFormDeserializer ddmFormDeserializer, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer, DLFileEntryLocalService dlFileEntryLocalService, JSONFactory jsonFactory) {
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._jsonFactory = jsonFactory;
    }

    protected DDMForm deserialize(String content) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._ddmFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(9);
        sb.append("select DDMContent.contentId, DDMContent.data_, ");
        sb.append("DDMStructureVersion.structureVersionId, ");
        sb.append("DDMStructureVersion.definition from DDMContent inner join ");
        sb.append("DDMStorageLink on DDMContent.contentId = ");
        sb.append("DDMStorageLink.classPK inner join DDMStructureVersion on ");
        sb.append("DDMStorageLink.structureVersionId = ");
        sb.append("DDMStructureVersion.structureVersionId where ");
        sb.append("DDMStructureVersion.definition like ");
        sb.append("'%ddm-documentlibrary%'");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                DDMForm ddmForm = this.deserialize(rs.getString("definition"));
                List ddmFormFields = ddmForm.getDDMFormFields();
                Stream stream = ddmFormFields.stream();
                List documentLibraryDDMFormFields = stream.filter(ddmFormField -> Objects.equals(ddmFormField.getType(), "ddm-documentlibrary")).collect(Collectors.toList());
                if (documentLibraryDDMFormFields.isEmpty()) continue;
                String data = rs.getString("data_");
                DDMFormValues ddmFormValues = this.deserialize(data, ddmForm);
                this.transformDocumentLibraryDDMFormFieldValues(ddmFormValues);
                ps2.setString(1, this.serialize(ddmFormValues));
                ps2.setLong(2, rs.getLong("contentId"));
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected String serialize(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    protected void transformDocumentLibraryDDMFormFieldValues(DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new DocumentLibraryDDMFormFieldValueTransformer());
        ddmFormValuesTransformer.transform();
    }

    private class DocumentLibraryDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private DocumentLibraryDDMFormFieldValueTransformer() {
        }

        public String getFieldType() {
            return "ddm-documentlibrary";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                if (Validator.isNull((String)valueString)) continue;
                JSONObject jsonObject = UpgradeDDMFormDocumentLibraryFields.this._jsonFactory.createJSONObject(valueString);
                long groupId = jsonObject.getLong("groupId");
                String uuid = jsonObject.getString("uuid");
                DLFileEntry dlFileEntry = UpgradeDDMFormDocumentLibraryFields.this._dlFileEntryLocalService.fetchDLFileEntryByUuidAndGroupId(uuid, groupId);
                if (dlFileEntry == null) continue;
                jsonObject.put("title", dlFileEntry.getTitle());
                value.addString(locale, jsonObject.toString());
            }
        }
    }
}

