/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v3_2_2;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeDDMFormFieldValidation
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public UpgradeDDMFormFieldValidation(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select structureId, definition from DDMStructure where classNameId = ? ");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = this.connection.prepareStatement("select structureVersionId, definition from DDMStructureVersion where structureId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId((String)"com.liferay.dynamic.data.mapping.model.DDMFormInstance"));
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    ResultSet rs2;
                    block71: {
                        String definition = rs.getString("definition");
                        ps2.setString(1, this._upgradeDefinition(definition));
                        long structureId = rs.getLong("structureId");
                        ps2.setLong(2, structureId);
                        ps2.addBatch();
                        ps3.setLong(1, structureId);
                        rs2 = ps3.executeQuery();
                        Throwable throwable = null;
                        try {
                            while (rs2.next()) {
                                definition = rs2.getString("definition");
                                ps4.setString(1, this._upgradeDefinition(definition));
                                long structureVersionId = rs2.getLong("structureVersionId");
                                ps4.setLong(2, structureVersionId);
                                ps4.addBatch();
                            }
                            if (rs2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (rs2 == null) throw throwable3;
                                if (throwable == null) {
                                    rs2.close();
                                    throw throwable3;
                                }
                                try {
                                    rs2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            rs2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    rs2.close();
                }
            }
            ps2.executeBatch();
            ps4.executeBatch();
            return;
        }
    }

    private Map<String, String> _dissect(String expression, String name, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(expression);
        matcher.find();
        String parameter = matcher.group(2);
        return HashMapBuilder.put((Object)"name", (Object)name).put((Object)"parameter", (Object)parameter).put((Object)"value", (Object)StringUtil.replace((String)expression, (String)parameter, (String)"{parameter}")).build();
    }

    private Map<String, String> _dissectExpression(String expression) {
        if (expression.matches("NOT\\(contains\\((.+), \"(.*)\"\\)\\)")) {
            return this._dissect(expression, "notContains", "NOT\\(contains\\((.+), \"(.*)\"\\)\\)");
        }
        if (expression.matches("contains\\((.+), \"(.*)\"\\)")) {
            return this._dissect(expression, "contains", "contains\\((.+), \"(.*)\"\\)");
        }
        if (expression.matches("isURL\\((.+)\\)")) {
            return HashMapBuilder.put((Object)"name", (Object)"url").put((Object)"parameter", (Object)"").put((Object)"value", (Object)expression).build();
        }
        if (expression.matches("isEmailAddress\\((.+)\\)")) {
            return HashMapBuilder.put((Object)"name", (Object)"email").put((Object)"parameter", (Object)"").put((Object)"value", (Object)expression).build();
        }
        if (expression.matches("match\\((.+), \"(.*)\"\\)")) {
            return this._dissect(expression, "regularExpression", "match\\((.+), \"(.*)\"\\)");
        }
        if (expression.matches("(.+)<(\\d+\\.?\\d*)?")) {
            return this._dissect(expression, "lt", "(.+)<(\\d+\\.?\\d*)?");
        }
        if (expression.matches("(.+)<=(\\d+\\.?\\d*)?")) {
            return this._dissect(expression, "lteq", "(.+)<=(\\d+\\.?\\d*)?");
        }
        if (expression.matches("(.+)==(\\d+\\.?\\d*)?")) {
            return this._dissect(expression, "eq", "(.+)==(\\d+\\.?\\d*)?");
        }
        if (expression.matches("(.+)>(\\d+\\.?\\d*)?")) {
            return this._dissect(expression, "gt", "(.+)>(\\d+\\.?\\d*)?");
        }
        if (expression.matches("(.+)>=(\\d+\\.?\\d*)?")) {
            return this._dissect(expression, "gteq", "(.+)>=(\\d+\\.?\\d*)?");
        }
        return HashMapBuilder.put((Object)"name", (Object)"").put((Object)"parameter", (Object)"").put((Object)"value", (Object)expression).build();
    }

    private String _upgradeDefinition(String definition) throws PortalException {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(definition);
        this._upgradeFields(jsonObject.getJSONArray("availableLanguageIds"), jsonObject.getJSONArray("fields"));
        return jsonObject.toString();
    }

    private void _upgradeFields(JSONArray availableLanguageIdsJSONArray, JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONArray nestedFieldsJSONArray;
            JSONObject jsonObject = fieldsJSONArray.getJSONObject(i);
            JSONObject validationJSONObject = jsonObject.getJSONObject("validation");
            if (validationJSONObject != null) {
                String expression = validationJSONObject.getString("expression");
                if (Validator.isNull((String)expression)) {
                    jsonObject.remove("validation");
                } else {
                    JSONObject expressionJSONObject = validationJSONObject.getJSONObject("expression");
                    if (expressionJSONObject == null) {
                        this._upgradeValidation(availableLanguageIdsJSONArray, expression, validationJSONObject);
                    } else if (expressionJSONObject.isNull("name")) {
                        this._upgradeValidation(availableLanguageIdsJSONArray, expressionJSONObject.getString("value"), validationJSONObject);
                    }
                }
            }
            if ((nestedFieldsJSONArray = jsonObject.getJSONArray("nestedFields")) == null) continue;
            this._upgradeFields(availableLanguageIdsJSONArray, nestedFieldsJSONArray);
        }
    }

    private void _upgradeValidation(JSONArray availableLanguageIdsJSONArray, String expression, JSONObject validationJSONObject) {
        Map<String, String> expressionParts = this._dissectExpression(expression);
        String parameter = expressionParts.remove("parameter");
        validationJSONObject.put("expression", expressionParts);
        HashMap<String, String> localizedValue = new HashMap<String, String>();
        for (int j = 0; j < availableLanguageIdsJSONArray.length(); ++j) {
            localizedValue.put(availableLanguageIdsJSONArray.getString(j), parameter);
        }
        validationJSONObject.put("parameter", localizedValue);
    }
}

