/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage.impl;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class StringFieldRenderer
extends BaseFieldRenderer {
    protected String doRender(Field field, Locale locale) throws Exception {
        String fieldType = this.getFieldType(field);
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) continue;
            if (fieldType.equals("select")) {
                valueString = this.handleSelectFieldValue(field, valueString, locale);
            } else if (fieldType.equals("radio")) {
                return this.handleRadioFieldValue(field, String.valueOf(value), locale);
            }
            values.add(valueString);
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) throws Exception {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        String fieldType = this.getFieldType(field);
        String valueString = String.valueOf(value);
        if (fieldType.equals("select")) {
            return this.handleSelectFieldValue(field, valueString, locale);
        }
        if (fieldType.equals("radio")) {
            return this.handleRadioFieldValue(field, valueString, locale);
        }
        return valueString;
    }

    protected LocalizedValue getFieldOptionLabel(Field field, String optionValue) throws Exception {
        DDMStructure ddmStructure = field.getDDMStructure();
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(field.getName());
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        return ddmFormFieldOptions.getOptionLabels(optionValue);
    }

    protected String getFieldType(Field field) throws Exception {
        DDMStructure ddmStructure = field.getDDMStructure();
        return ddmStructure.getFieldType(field.getName());
    }

    protected String handleRadioFieldValue(Field field, String value, Locale locale) throws Exception {
        if (Validator.isNull((String)value)) {
            return "";
        }
        LocalizedValue label = this.getFieldOptionLabel(field, value);
        if (label == null) {
            return value;
        }
        return GetterUtil.getString((String)label.getString(locale));
    }

    protected String handleSelectFieldValue(Field field, String json, Locale locale) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        if (jsonArray.length() == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(jsonArray.length() * 2);
        for (int i = 0; i < jsonArray.length(); ++i) {
            LocalizedValue localizedValue = this.getFieldOptionLabel(field, jsonArray.getString(i));
            if (localizedValue != null) {
                sb.append(localizedValue.getString(locale));
            } else {
                sb.append(jsonArray.getString(i));
            }
            sb.append(", ");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

