/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage.impl;

import com.liferay.dynamic.data.mapping.storage.StorageAdapter;
import com.liferay.dynamic.data.mapping.storage.StorageAdapterRegistry;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={StorageAdapterRegistry.class})
public class StorageAdapterRegistryImpl
implements StorageAdapterRegistry {
    @Reference(target="(component.name=com.liferay.dynamic.data.mapping.storage.impl.JSONStorageAdapter)")
    private StorageAdapter _defaultStorageAdapter;
    private final Map<String, StorageAdapter> _storageAdaptersMap = new ConcurrentHashMap<String, StorageAdapter>();

    public StorageAdapter getDefaultStorageAdapter() {
        return this._defaultStorageAdapter;
    }

    public StorageAdapter getStorageAdapter(String storageType) {
        return this._storageAdaptersMap.get(storageType);
    }

    public Set<String> getStorageTypes() {
        return this._storageAdaptersMap.keySet();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, service=StorageAdapter.class)
    public void setStorageAdapter(StorageAdapter storageAdapter) {
        this._storageAdaptersMap.put(storageAdapter.getStorageType(), storageAdapter);
    }

    public void unsetStorageAdapter(StorageAdapter storageAdapter) {
        this._storageAdaptersMap.remove(storageAdapter);
    }
}

