/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage.impl;

import com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class GeolocationFieldRenderer
extends BaseFieldRenderer {
    private static final Log _log = LogFactoryUtil.getLog(GeolocationFieldRenderer.class);

    protected String doRender(Field field, Locale locale) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) continue;
            values.add(this.handleJSON(valueString, locale));
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        return this.handleJSON(String.valueOf(value), locale);
    }

    protected String handleJSON(String value, Locale locale) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONFactoryUtil.createJSONObject((String)value);
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
            }
            return "";
        }
        StringBundler sb = new StringBundler(7);
        sb.append(LanguageUtil.get((Locale)locale, (String)"latitude"));
        sb.append(": ");
        double latitude = jsonObject.getDouble("latitude");
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        sb.append(numberFormat.format(latitude));
        sb.append(", ");
        sb.append(LanguageUtil.get((Locale)locale, (String)"longitude"));
        sb.append(": ");
        double longitude = jsonObject.getDouble("longitude");
        sb.append(numberFormat.format(longitude));
        return sb.toString();
    }
}

