/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v2_0_3;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeDDMFormInstanceEntries
extends UpgradeProcess {
    private final JSONFactory _jsonFactory;

    public UpgradeDDMFormInstanceEntries(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select DDMContent.contentId, DDMContent.data_ from ", "DDMFormInstanceRecordVersion inner join DDMFormInstance ", "on DDMFormInstanceRecordVersion.formInstanceId = ", "DDMFormInstance.formInstanceId inner join DDMContent on ", "DDMFormInstanceRecordVersion.storageId = DDMContent.", "contentId"}));
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String data = rs.getString("data_");
                ps2.setString(1, this.updateFieldValuesToLocalizable(data));
                long contentId = rs.getLong("contentId");
                ps2.setLong(2, contentId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected String updateFieldValuesToLocalizable(String definition) throws PortalException {
        JSONObject ddmFormValuesJSONObject = this._jsonFactory.createJSONObject(definition);
        String defaultLanguageId = ddmFormValuesJSONObject.getString("defaultLanguageId");
        JSONArray fieldsJSONArray = ddmFormValuesJSONObject.getJSONArray("fieldValues");
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            Object value = fieldJSONObject.get("value");
            if (!(value instanceof String)) continue;
            JSONObject localizedValueJSONObject = this._jsonFactory.createJSONObject();
            localizedValueJSONObject.put(defaultLanguageId, fieldJSONObject.getString("value"));
            fieldJSONObject.put("value", localizedValueJSONObject);
        }
        return ddmFormValuesJSONObject.toJSONString();
    }
}

