/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRendererRegistryUtil;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.dynamic.data.mapping.render.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DDMFormRendererImpl
implements DDMFormRenderer {
    public String render(DDMForm ddmForm, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws PortalException {
        List ddmFormFields = ddmForm.getDDMFormFields();
        StringBundler sb = new StringBundler(ddmFormFields.size());
        ddmFormFieldRenderingContext.setProperty("fieldNamespaceSet", new HashSet());
        for (DDMFormField ddmFormField : ddmFormFields) {
            if (this.isDDMFormFieldSkippable(ddmFormField, ddmFormFieldRenderingContext)) continue;
            DDMFormFieldRenderer ddmFormFieldRenderer = DDMFormFieldRendererRegistryUtil.getDDMFormFieldRenderer((String)ddmFormField.getType());
            sb.append(ddmFormFieldRenderer.render(ddmFormField, ddmFormFieldRenderingContext));
        }
        this.clearDDMFieldsCounter(ddmFormFieldRenderingContext);
        return sb.toString();
    }

    protected void clearDDMFieldsCounter(DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        String fieldsCounterKey;
        HttpServletRequest request = ddmFormFieldRenderingContext.getHttpServletRequest();
        DDMFieldsCounter ddmFieldsCounter = (DDMFieldsCounter)request.getAttribute(fieldsCounterKey = ddmFormFieldRenderingContext.getPortletNamespace() + ddmFormFieldRenderingContext.getNamespace() + "fieldsCount");
        if (ddmFieldsCounter != null) {
            ddmFieldsCounter.clear();
        }
    }

    protected boolean isDDMFormFieldSkippable(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        if (!ddmFormFieldRenderingContext.isReadOnly() || ddmFormFieldRenderingContext.isShowEmptyFieldLabel()) {
            return false;
        }
        Fields fields = ddmFormFieldRenderingContext.getFields();
        if (fields.contains(ddmFormField.getName())) {
            return false;
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            if (this.isDDMFormFieldSkippable(nestedDDMFormField, ddmFormFieldRenderingContext)) continue;
            return false;
        }
        return true;
    }
}

