/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dynamic.data.mapping.service.base;

import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionServiceUtil;
import com.liferay.dynamic.data.mapping.service.persistence.DDMFormInstanceRecordVersionPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.spring.extender.service.ServiceReference;

import java.sql.Connection;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the ddm form instance record version remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.dynamic.data.mapping.service.impl.DDMFormInstanceRecordVersionServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.dynamic.data.mapping.service.impl.DDMFormInstanceRecordVersionServiceImpl
 * @generated
 */
public abstract class DDMFormInstanceRecordVersionServiceBaseImpl
	extends BaseServiceImpl
	implements DDMFormInstanceRecordVersionService, IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>DDMFormInstanceRecordVersionService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>DDMFormInstanceRecordVersionServiceUtil</code>.
	 */

	/**
	 * Returns the ddm form instance record version local service.
	 *
	 * @return the ddm form instance record version local service
	 */
	public com.liferay.dynamic.data.mapping.service.
		DDMFormInstanceRecordVersionLocalService
			getDDMFormInstanceRecordVersionLocalService() {

		return ddmFormInstanceRecordVersionLocalService;
	}

	/**
	 * Sets the ddm form instance record version local service.
	 *
	 * @param ddmFormInstanceRecordVersionLocalService the ddm form instance record version local service
	 */
	public void setDDMFormInstanceRecordVersionLocalService(
		com.liferay.dynamic.data.mapping.service.
			DDMFormInstanceRecordVersionLocalService
				ddmFormInstanceRecordVersionLocalService) {

		this.ddmFormInstanceRecordVersionLocalService =
			ddmFormInstanceRecordVersionLocalService;
	}

	/**
	 * Returns the ddm form instance record version remote service.
	 *
	 * @return the ddm form instance record version remote service
	 */
	public DDMFormInstanceRecordVersionService
		getDDMFormInstanceRecordVersionService() {

		return ddmFormInstanceRecordVersionService;
	}

	/**
	 * Sets the ddm form instance record version remote service.
	 *
	 * @param ddmFormInstanceRecordVersionService the ddm form instance record version remote service
	 */
	public void setDDMFormInstanceRecordVersionService(
		DDMFormInstanceRecordVersionService
			ddmFormInstanceRecordVersionService) {

		this.ddmFormInstanceRecordVersionService =
			ddmFormInstanceRecordVersionService;
	}

	/**
	 * Returns the ddm form instance record version persistence.
	 *
	 * @return the ddm form instance record version persistence
	 */
	public DDMFormInstanceRecordVersionPersistence
		getDDMFormInstanceRecordVersionPersistence() {

		return ddmFormInstanceRecordVersionPersistence;
	}

	/**
	 * Sets the ddm form instance record version persistence.
	 *
	 * @param ddmFormInstanceRecordVersionPersistence the ddm form instance record version persistence
	 */
	public void setDDMFormInstanceRecordVersionPersistence(
		DDMFormInstanceRecordVersionPersistence
			ddmFormInstanceRecordVersionPersistence) {

		this.ddmFormInstanceRecordVersionPersistence =
			ddmFormInstanceRecordVersionPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	public void afterPropertiesSet() {
		DDMFormInstanceRecordVersionServiceUtil.setService(
			ddmFormInstanceRecordVersionService);
	}

	public void destroy() {
		DDMFormInstanceRecordVersionServiceUtil.setService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return DDMFormInstanceRecordVersionService.class.getName();
	}

	protected Class<?> getModelClass() {
		return DDMFormInstanceRecordVersion.class;
	}

	protected String getModelClassName() {
		return DDMFormInstanceRecordVersion.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource =
			ddmFormInstanceRecordVersionPersistence.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@BeanReference(
		type = com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService.class
	)
	protected com.liferay.dynamic.data.mapping.service.
		DDMFormInstanceRecordVersionLocalService
			ddmFormInstanceRecordVersionLocalService;

	@BeanReference(type = DDMFormInstanceRecordVersionService.class)
	protected DDMFormInstanceRecordVersionService
		ddmFormInstanceRecordVersionService;

	@BeanReference(type = DDMFormInstanceRecordVersionPersistence.class)
	protected DDMFormInstanceRecordVersionPersistence
		ddmFormInstanceRecordVersionPersistence;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		DDMFormInstanceRecordVersionServiceBaseImpl.class);

}