/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingException;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.template.react.renderer.ComponentDescriptor;
import com.liferay.portal.template.react.renderer.ReactRenderer;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DDMFormRenderer.class})
public class DDMFormRendererImpl
implements DDMFormRenderer {
    @Reference
    private DDM _ddm;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private ReactRenderer _reactRenderer;

    public Map<String, Object> getDDMFormTemplateContext(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws Exception {
        Map ddmFormTemplateContext = this._ddmFormTemplateContextFactory.create(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        ddmFormTemplateContext.put("editable", false);
        ddmFormTemplateContext.remove("fieldTypes");
        HttpServletRequest httpServletRequest = ddmFormRenderingContext.getHttpServletRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ddmFormTemplateContext.put("spritemap", themeDisplay.getPathThemeSpritemap());
        return ddmFormTemplateContext;
    }

    public String render(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this._render(ddmForm, ddmFormLayout, ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmFormRenderingException) {
            throw ddmFormRenderingException;
        }
        catch (Exception exception) {
            throw new DDMFormRenderingException((Throwable)exception);
        }
    }

    public String render(DDMForm ddmForm, DDMFormRenderingContext ddmFormRenderingContext) throws DDMFormRenderingException {
        try {
            return this._render(ddmForm, this._ddm.getDefaultDDMFormLayout(ddmForm), ddmFormRenderingContext);
        }
        catch (DDMFormRenderingException ddmFormRenderingException) {
            throw ddmFormRenderingException;
        }
        catch (Exception exception) {
            throw new DDMFormRenderingException((Throwable)exception);
        }
    }

    private String _render(DDMForm ddmForm, DDMFormLayout ddmFormLayout, DDMFormRenderingContext ddmFormRenderingContext) throws Exception {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        writer.append("<div id=\"");
        writer.append(ddmFormRenderingContext.getContainerId());
        writer.append("\">");
        this._reactRenderer.renderReact(new ComponentDescriptor("{FormView} from data-engine-js-components-web"), this.getDDMFormTemplateContext(ddmForm, ddmFormLayout, ddmFormRenderingContext), ddmFormRenderingContext.getHttpServletRequest(), (Writer)writer);
        writer.append("</div>");
        return writer.toString();
    }
}

