/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal.servlet;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/dynamic-data-mapping-form-field-types", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.form.renderer.internal.servlet.DDMFormFieldTypesServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-form-field-types/*"}, service={Servlet.class})
public class DDMFormFieldTypesServlet
extends HttpServlet {
    @Reference
    protected NPMResolver npmResolver;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormFieldTypesServlet.class);
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private JSONFactory _jsonFactory;

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.createContext(httpServletRequest, httpServletResponse);
        super.service(httpServletRequest, httpServletResponse);
    }

    protected void createContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block2: {
            try {
                EventsProcessorUtil.process((String)"servlet.service.events.pre", (String[])PropsValues.SERVLET_SERVICE_EVENTS_PRE, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            }
            catch (ActionException actionException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)actionException);
            }
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        JSONArray fieldTypesJSONArray = this._jsonFactory.createJSONArray();
        Set ddmFormFieldTypeNames = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeNames();
        Stream stream = ddmFormFieldTypeNames.stream();
        stream.map(ddmFormFieldTypeName -> this._getFieldTypeMetadataJSONObject((String)ddmFormFieldTypeName, Collections.emptyMap())).forEach(arg_0 -> ((JSONArray)fieldTypesJSONArray).put(arg_0));
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)fieldTypesJSONArray.toString());
    }

    private JSONObject _getFieldTypeMetadataJSONObject(String ddmFormFieldName, Map<String, Object> configuration) {
        JSONObjectImpl jsonObject = new JSONObjectImpl();
        return jsonObject.put("configuration", () -> {
            if (!configuration.isEmpty()) {
                return configuration;
            }
            return null;
        }).put("javaScriptModule", this._resolveModuleName(this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormFieldName))).put("name", ddmFormFieldName);
    }

    private String _resolveModuleName(DDMFormFieldType ddmFormFieldType) {
        if (Validator.isNull((String)ddmFormFieldType.getModuleName())) {
            return "";
        }
        if (ddmFormFieldType.isCustomDDMFormFieldType()) {
            return ddmFormFieldType.getModuleName();
        }
        return this.npmResolver.resolveModuleName(ddmFormFieldType.getModuleName());
    }
}

