/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal.helper;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DDMFormTemplateContextFactoryHelper {
    private static final Pattern _pattern = Pattern.compile("'?([\\w]+)'?\\s*[,\\)]\\s*");

    public Set<String> getEvaluableDDMFormFieldNames(DDMForm ddmForm, DDMFormLayout ddmFormLayout) {
        HashSet<String> expressionParameterNames = new HashSet<String>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Set<String> ddmFormFieldNames = ddmFormFieldsMap.keySet();
        List ddmFormRules = ddmFormLayout.getDDMFormRules();
        if (ListUtil.isEmpty((List)ddmFormRules)) {
            ddmFormRules = ddmForm.getDDMFormRules();
        }
        expressionParameterNames.addAll(this._getParameterNamesByDDMFormRules(ddmFormRules));
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            if (this._isDDMFormFieldEvaluable(ddmFormField)) {
                expressionParameterNames.add(ddmFormField.getName());
            }
            expressionParameterNames.addAll(this._getParameterNamesByExpression(ddmFormField.getVisibilityExpression()));
        }
        ddmFormFieldNames.retainAll(expressionParameterNames);
        return ddmFormFieldNames;
    }

    private Set<String> _getParameterNamesByDDMFormRules(List<DDMFormRule> ddmFormRules) {
        HashSet<String> parameterNames = new HashSet<String>();
        for (DDMFormRule ddmFormRule : ddmFormRules) {
            parameterNames.addAll(this._getParameterNamesByExpression(ddmFormRule.getCondition()));
            for (String action : ddmFormRule.getActions()) {
                parameterNames.addAll(this._getParameterNamesByExpression(action));
            }
        }
        return parameterNames;
    }

    private Set<String> _getParameterNamesByExpression(String expression) {
        if (Validator.isNull((String)expression)) {
            return Collections.emptySet();
        }
        HashSet<String> parameterNames = new HashSet<String>();
        Matcher matcher = _pattern.matcher(expression);
        while (matcher.find()) {
            parameterNames.add(matcher.group(1));
        }
        return parameterNames;
    }

    private boolean _isDDMFormFieldEvaluable(DDMFormField ddmFormField) {
        if (Objects.equals(ddmFormField.getType(), "object-relationship") || GetterUtil.getBoolean((Object)ddmFormField.getProperty("inputMask")) || GetterUtil.getBoolean((Object)ddmFormField.getProperty("requireConfirmation")) || GetterUtil.getBoolean((Object)ddmFormField.getProperty("required"))) {
            return true;
        }
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        return ddmFormFieldValidation != null && ddmFormFieldValidation.getDDMFormFieldValidationExpression() != null;
    }
}

