Liferay.Loader.define('dynamic-data-mapping-form-renderer$moment@2.24.0/src/lib/units/day-of-year', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { addFormatToken } from '../format/format';
        import { addUnitAlias } from './aliases';
        import { addUnitPriority } from './priorities';
        import { addRegexToken, match3, match1to3 } from '../parse/regex';
        import { daysInYear } from './year';
        import { createUTCDate } from '../create/date-from-array';
        import { addParseToken } from '../parse/token';
        import toInt from '../utils/to-int';

        // FORMATTING

        addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

        // ALIASES

        addUnitAlias('dayOfYear', 'DDD');

        // PRIORITY
        addUnitPriority('dayOfYear', 4);

        // PARSING

        addRegexToken('DDD', match1to3);
        addRegexToken('DDDD', match3);
        addParseToken(['DDD', 'DDDD'], function (input, array, config) {
            config._dayOfYear = toInt(input);
        });

        // HELPERS

        // MOMENTS

        export function getSetDayOfYear(input) {
            var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
            return input == null ? dayOfYear : this.add(input - dayOfYear, 'd');
        }
    }
});
//# sourceMappingURL=day-of-year.js.map