/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

// Utils

export {default as compose} from './util/compose.es';
export {normalizeFieldName} from './util/fields.es';
export {
	getRepeatedIndex,
	generateName,
	generateInstanceId,
	parseName,
} from './util/repeatable.es';
export {PagesVisitor, RulesVisitor} from './util/visitors.es';
export * as FormSupport from './util/FormSupport.es';
export {getConnectedReactComponentAdapter} from './util/ReactComponentAdapter.es';
export {getUid} from './util/formId.es';
export {parseProps} from './util/parseProps.es';
export {makeFetch, convertToFormData} from './util/fetch.es';
export {default as setDataRecord} from './util/setDataRecord.es';

// Form/Data Engine Core

export {default as Pages} from './core/components/Pages.es';
export {Field} from './core/components/Field/Field.es';
export {FieldStateless} from './core/components/Field/FieldStateless.es';
export {EVENT_TYPES, MAPPED_EVENT_TYPES} from './core/actions/eventTypes.es';
export {PageProvider, usePage} from './core/hooks/usePage.es';
export {useFieldTypesResource} from './core/hooks/useResource.es';
export {elementSetAdded} from './core/thunks/elementSetAdded.es';
export {FormProvider, useForm, useFormState} from './core/hooks/useForm.es';
export {ConfigProvider, useConfig} from './core/hooks/useConfig.es';
export {Layout} from './core/components/PageRenderer/Layout.es';
export * as DefaultVariant from './core/components/PageRenderer/DefaultVariant.es';

// Custom Form

export {EVENT_TYPES as FORM_EVENT_TYPES} from './custom/form/eventTypes.es';

// Containers

export {FormView} from './custom/form/FormView.es';
export {default as LegacyFormBuilder} from './custom/form/LegacyFormBuilder.es';
export {
	FormFieldSettings,
	FormFieldSettingsAdapter,
} from './custom/form/FormFieldSettings.es';
