/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {EVENT_TYPES as CORE_EVENT_TYPES} from '../../../core/actions/eventTypes.es';
import {evaluate} from '../../../util/evaluation.es';
import {PagesVisitor} from '../../../util/visitors.es';

export default function nextPage({
	activePage,
	defaultLanguageId,
	editingLanguageId,
	formId,
	groupId,
	pages,
	portletNamespace,
	rules,
	viewMode,
}) {
	return (dispatch) => {
		evaluate(null, {
			defaultLanguageId,
			editingLanguageId,
			groupId,
			pages,
			portletNamespace,
			rules,
			viewMode,
		}).then((evaluatedPages) => {
			let validPage = true;
			const visitor = new PagesVisitor(evaluatedPages);

			visitor.mapFields(
				({valid}, fieldIndex, columnIndex, rowIndex, pageIndex) => {
					if (activePage === pageIndex && !valid) {
						validPage = false;
					}
				},
				true,
				true
			);

			if (validPage) {
				const nextActivePageIndex = evaluatedPages.findIndex(
					({enabled}, index) => enabled && index > activePage
				);

				const activePageUpdated = Math.min(
					nextActivePageIndex,
					pages.length - 1
				);

				dispatch({
					payload: {activePage: activePageUpdated},
					type: CORE_EVENT_TYPES.PAGE.CHANGE,
				});

				Liferay.fire('ddmFormPageShow', {
					formId,
					page: activePageUpdated,
					title: pages[activePageUpdated].title,
				});
			}
			else {
				dispatch({
					payload: {newPages: evaluatedPages, pageIndex: activePage},
					type: CORE_EVENT_TYPES.PAGE.VALIDATION_FAILED,
				});
			}
		});
	};
}
