/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import ClayButton from '@clayui/button';
import React from 'react';

import * as DefaultVariant from '../../../core/components/PageRenderer/DefaultVariant.es';
import {useConfig} from '../../../core/hooks/useConfig.es';
import {Pagination} from '../components/Pagination.es';
import {PaginationControls} from '../components/PaginationControls.es';

export const Container = ({
	activePage,
	children,
	pageIndex,
	pages,
	readOnly,
	strings,
}) => {
	const {showSubmitButton, submitLabel} = useConfig();

	return (
		<div className="ddm-form-page-container paginated">
			<DefaultVariant.Container
				activePage={activePage}
				pageIndex={pageIndex}
			>
				{children}
			</DefaultVariant.Container>

			{pageIndex === activePage && (
				<>
					{pages.length > 0 && (
						<>
							<Pagination activePage={activePage} pages={pages} />
							<PaginationControls
								activePage={activePage}
								readOnly={readOnly}
								showSubmitButton={showSubmitButton}
								strings={strings}
								submitLabel={submitLabel}
								total={pages.length}
							/>
						</>
					)}

					{!pages.length && showSubmitButton && (
						<ClayButton
							className="float-right lfr-ddm-form-submit"
							id="ddm-form-submit"
							type="submit"
						>
							{submitLabel}
						</ClayButton>
					)}
				</>
			)}
		</div>
	);
};

Container.displayName = 'PaginatedVariant.Container';
