/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {EVENT_TYPES} from '../eventTypes.es';

/**
 * NOTE: This is a literal copy of the old LayoutProvider logic. Small changes
 * were made only to adapt to the reducer.
 */
export default (state, action) => {
	switch (action.type) {
		case EVENT_TYPES.PAGINATION.NEXT: {
			const {activePage, pages} = state;

			return {
				activePage: Math.min(activePage + 1, pages.length - 1),
			};
		}
		case EVENT_TYPES.PAGINATION.CHANGE: {
			const {activePage} = state;

			return {
				activePage: Math.max(activePage - 1, 0),
			};
		}
		default:
			return state;
	}
};
