/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {useEffect, useState} from 'react';

export function useResizeObserver(targetRef) {
	const [contentRect, setContentRect] = useState({});

	useEffect(() => {
		let resizeObserver;

		if ('ResizeObserver' in window) {
			resizeObserver = new ResizeObserver((entries) => {
				const {
					bottom,
					height,
					left,
					right,
					top,
					width,
				} = entries[0].contentRect;

				setContentRect({bottom, height, left, right, top, width});
			});

			if (targetRef.current) {
				resizeObserver.observe(targetRef.current);
			}

			return () => resizeObserver.disconnect();
		}
	}, [targetRef]);

	return contentRect;
}
