/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import {useCallback} from 'react';

import {useConfig} from './useConfig.es';
import {useFormState} from './useForm.es';

/**
 * This hook is a partial function that removes the need to pass the same
 * properties every time they are called, this is only for thunks that use
 * the `evaluate` function.
 */
export const useEvaluate = (thunk) => {
	const {groupId, portletNamespace, viewMode} = useConfig();
	const {defaultLanguageId, editingLanguageId, pages, rules} = useFormState();

	return useCallback(
		(args) =>
			thunk({
				defaultLanguageId,
				editingLanguageId,
				groupId,
				pages,
				portletNamespace,
				rules,
				viewMode,
				...args,
			}),
		[
			defaultLanguageId,
			editingLanguageId,
			groupId,
			pages,
			portletNamespace,
			rules,
			thunk,
			viewMode,
		]
	);
};
