/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import ClayLayout from '@clayui/layout';
import ClayTabs from '@clayui/tabs';
import React from 'react';

import {EVENT_TYPES} from '../actions/eventTypes.es';
import {useForm} from '../hooks/useForm.es';

export const Tabs = ({activePage, pages}) => {
	const dispatch = useForm();

	return (
		<nav className="component-tbar ddm-form-tabs mb-3 tbar">
			<ClayLayout.ContainerFluid className="pr-0">
				<ClayTabs>
					{pages.map((page, index) => (
						<ClayTabs.Item
							active={index === activePage}
							disabled={!page.enabled}
							key={index}
							onClick={() =>
								dispatch({
									payload: {activePage: index},
									type: EVENT_TYPES.PAGE.CHANGE,
								})
							}
						>
							<span className="navbar-text-truncate">
								{page.title}
							</span>
						</ClayTabs.Item>
					))}
				</ClayTabs>
			</ClayLayout.ContainerFluid>
		</nav>
	);
};
