/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

import React, {useEffect, useRef} from 'react';

const FieldDragPreview = ({containerRef}) => {
	const ref = useRef(null);

	/**
	 * This hack was needed to capture the field snapshot.
	 * Currently the Field is loaded lazily and the preview
	 * will look like a loading state field.
	 */
	useEffect(() => {

		/**
		 * It copies the width of the field and clone the DOM element
		 * to replace the ref inner FieldDragPreview
		 */
		const {width} = getComputedStyle(containerRef.current);
		const element = containerRef.current.cloneNode(true);
		const fieldDragPreviewRef = ref.current;

		fieldDragPreviewRef.parentElement.style.width = width;

		fieldDragPreviewRef.appendChild(element);

		return () => {
			fieldDragPreviewRef.remove();
		};
	}, [containerRef, ref]);

	return (
		<div className="ddm-drag dragging">
			<div ref={ref} />
		</div>
	);
};

export default FieldDragPreview;
