/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

const LEGACY_EVENTS = {
	FIELD_EVALUATION_ERROR: 'evaluationError',
};

const PAGE = {
	CHANGE: 'page_change',
	UPDATE: 'pages_update',
	VALIDATION_FAILED: 'page_validation_failed',
};

const FIELD = {
	ADD: 'field_add',
	BLUR: 'field_blur',
	CHANGE: 'field_change',
	CLICK: 'field_click',
	DELETE: 'field_delete',
	DUPLICATE: 'field_duplicate',
	EVALUATE: 'field_evaluate',
	FOCUS: 'field_focus',
	HOVER: 'field_hover',
	REMOVED: 'field_removed',
	REPEATED: 'field_repeated',
};

const DND = {
	MOVE: 'field_move',
	RESIZE: 'field_resize',
};

const SECTION = {
	ADD: 'section_add',
};

const FIELD_SET = {
	ADD: 'fieldset_add',
};

const LANGUAGE = {
	ADD: 'language_add',
	CHANGE: 'language_change',
	DELETE: 'language_delete',
};

/**
 * Event mapping for compatibility with events for
 * the LayoutProvider component.
 */
export const MAPPED_EVENT_TYPES = {
	[DND.MOVE]: 'fieldMoved',
	[DND.RESIZE]: 'columnResized',
	[FIELD_SET.ADD]: 'fieldSetAdded',
	[FIELD.ADD]: 'fieldAdded',
	[FIELD.BLUR]: 'fieldBlurred',
	[FIELD.CHANGE]: 'fieldEdited',
	[FIELD.CLICK]: 'fieldClicked',
	[FIELD.DELETE]: 'fieldDeleted',
	[FIELD.DUPLICATE]: 'fieldDuplicated',
	[FIELD.EVALUATE]: 'focusedFieldEvaluationEnded',
	[FIELD.HOVER]: 'fieldHovered',
	[PAGE.VALIDATION_FAILED]: 'pageValidationFailed',
	[SECTION.ADD]: 'sectionAdded',
};

export const EVENT_TYPES = {
	...LEGACY_EVENTS,
	DND,
	FIELD,
	FIELD_SET,
	LANGUAGE,
	PAGE,
	SECTION,
};
