Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.74/js/util/FormSupport.es", ['module', 'exports', 'require', './visitors.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.updateColumn = exports.updateField = exports.getNestedIndexes = exports.getIndexes = exports.getField = exports.getColumnPosition = exports.getColumn = exports.getRow = exports.findFieldByName = exports.findFieldByFieldName = exports.findField = exports.visitNestedFields = exports.removeRow = exports.removeEmptyRows = exports.rowHasFields = exports.removeFields = exports.removeColumn = exports.setColumnFields = exports.isEmpty = exports.isEmptyPage = exports.isEmptyRow = exports.getParentField = exports.getFieldIndexes = exports.addFieldToColumn = exports.isEmptyColumn = exports.addColumn = exports.addRow = exports.implAddRow = exports.implAddColumn = void 0;

    var _visitors = require("./visitors.es");

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var implAddColumn = function implAddColumn(size) {
      var fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      return {
        fields: fields,
        size: size
      };
    };

    exports.implAddColumn = implAddColumn;

    var implAddRow = function implAddRow(size, fields) {
      return {
        columns: [implAddColumn(size, fields)]
      };
    };

    exports.implAddRow = implAddRow;

    var addRow = function addRow(pages, indexToAddRow, pageIndex) {
      var newRow = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : implAddRow(12, []);
      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.mapPages(function (page, currentPageIndex) {
        var newPage = page;

        if (pageIndex === currentPageIndex) {
          newPage = _objectSpread(_objectSpread({}, page), {}, {
            rows: [].concat(_toConsumableArray(page.rows.slice(0, indexToAddRow)), [newRow], _toConsumableArray(page.rows.slice(indexToAddRow)))
          });
        }

        return newPage;
      });
    };

    exports.addRow = addRow;

    var addColumn = function addColumn(pages, indexToAddColumn, pageIndex, rowIndex) {
      var newColumn = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : implAddColumn(11, []);
      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.mapRows(function (row, currentRowIndex, currentPageIndex) {
        var newRow = row;

        if (currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
          newRow = _objectSpread(_objectSpread({}, row), {}, {
            columns: [].concat(_toConsumableArray(row.columns.slice(0, indexToAddColumn)), [newColumn], _toConsumableArray(row.columns.slice(indexToAddColumn)))
          });
        }

        return newRow;
      });
    };

    exports.addColumn = addColumn;

    var isEmptyColumn = function isEmptyColumn(pages, pageIndex, rowIndex, columnIndex) {
      return pages[pageIndex].rows[rowIndex].columns[columnIndex].fields.length === 0;
    };

    exports.isEmptyColumn = isEmptyColumn;

    var addFieldToColumn = function addFieldToColumn(pages, pageIndex, rowIndex, columnIndex, field) {
      var numberOfRows = pages[pageIndex].rows.length;

      if (rowIndex >= numberOfRows) {
        var newRow = implAddRow(12, [field]);
        return addRow(pages, numberOfRows, pageIndex, newRow);
      }

      if (!isEmptyColumn(pages, pageIndex, rowIndex, columnIndex)) {
        pages = addRow(pages, rowIndex, pageIndex);
      }

      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.mapColumns(function (column, currentColumnIndex, currentRowIndex, currentPageIndex) {
        if (currentColumnIndex === columnIndex && currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
          return _objectSpread(_objectSpread({}, column), {}, {
            fields: [].concat(_toConsumableArray(column.fields), [field])
          });
        }

        return column;
      });
    };

    exports.addFieldToColumn = addFieldToColumn;

    var getFieldIndexes = function getFieldIndexes(pages, fieldName) {
      var indexes = {};
      var visitor = new _visitors.PagesVisitor(pages);
      visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
        if (typeof field === 'string' && field === fieldName || _typeof(field) === 'object' && field.fieldName === fieldName) {
          indexes = {
            columnIndex: columnIndex,
            fieldIndex: fieldIndex,
            pageIndex: pageIndex,
            rowIndex: rowIndex
          };
        }
      });
      return indexes;
    };

    exports.getFieldIndexes = getFieldIndexes;

    var getParentField = function getParentField(pages, fieldName) {
      var parentField;
      var visitor = new _visitors.PagesVisitor(pages);
      visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex, currentParentField) {
        if (field.fieldName === fieldName) {
          parentField = currentParentField;
        }
      }, true, true);
      return parentField;
    };

    exports.getParentField = getParentField;

    var isEmptyRow = function isEmptyRow(pages, pageIndex, rowIndex) {
      return pages[pageIndex].rows[rowIndex].columns.every(function (column, columnIndex) {
        return isEmptyColumn(pages, pageIndex, rowIndex, columnIndex);
      });
    };

    exports.isEmptyRow = isEmptyRow;

    var isEmptyPage = function isEmptyPage(pages, pageIndex) {
      return pages[pageIndex].rows.every(function (row, rowIndex) {
        return isEmptyRow(pages, pageIndex, rowIndex);
      });
    };

    exports.isEmptyPage = isEmptyPage;

    var isEmpty = function isEmpty(pages) {
      return pages.every(function (page, pageIndex) {
        return isEmptyPage(pages, pageIndex);
      });
    };

    exports.isEmpty = isEmpty;

    var setColumnFields = function setColumnFields(pages, pageIndex, rowIndex, columnIndex) {
      var fields = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];
      var numberOfRows = pages[Number(pageIndex)].rows.length;

      if (numberOfRows - 1 < rowIndex) {
        pages = addRow(pages, rowIndex, pageIndex);
        pages = addFieldToColumn(pages, pageIndex, rowIndex, columnIndex, fields);
      } else {
        pages[Number(pageIndex)].rows[Number(rowIndex)].columns[Number(columnIndex)].fields = fields;
      }

      return pages;
    };

    exports.setColumnFields = setColumnFields;

    var removeColumn = function removeColumn(pages, pageIndex, rowIndex, columnIndex) {
      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.mapRows(function (row, currentRowIndex, currentPageIndex) {
        var newRow = row;

        if (currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
          newRow = _objectSpread(_objectSpread({}, row), {}, {
            columns: row.columns.filter(function (col, currentColumnIndex) {
              return currentColumnIndex !== columnIndex;
            })
          });
        }

        return newRow;
      });
    };

    exports.removeColumn = removeColumn;

    var removeFields = function removeFields(pages, pageIndex, rowIndex, columnIndex) {
      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.mapColumns(function (column, currentColumnIndex, currentRowIndex, currentPageIndex) {
        var newColumn = _objectSpread({}, column);

        if (currentPageIndex === pageIndex && currentRowIndex === rowIndex && currentColumnIndex === columnIndex) {
          newColumn.fields = [];
        }

        return newColumn;
      });
    };

    exports.removeFields = removeFields;

    var rowHasFields = function rowHasFields(pages, pageIndex, rowIndex) {
      var hasFields = false;
      var page = pages[Number(pageIndex)];

      if (page) {
        var row = page.rows[Number(rowIndex)];

        if (row && row.columns) {
          hasFields = row.columns.some(function (column) {
            return column.fields.length;
          });
        }
      }

      return hasFields;
    };

    exports.rowHasFields = rowHasFields;

    var removeEmptyRows = function removeEmptyRows(pages, pageIndex) {
      return pages[pageIndex].rows.reduce(function (result, next, index) {
        if (rowHasFields(pages, pageIndex, index)) {
          result = [].concat(_toConsumableArray(result), [next]);
        }

        return result;
      }, []);
    };

    exports.removeEmptyRows = removeEmptyRows;

    var removeRow = function removeRow(pages, pageIndex, rowIndex) {
      pages[Number(pageIndex)].rows.splice(Number(rowIndex), 1);
      return pages;
    };

    exports.removeRow = removeRow;

    var visitNestedFields = function visitNestedFields(_ref, fn) {
      var nestedFields = _ref.nestedFields;

      if (Array.isArray(nestedFields)) {
        nestedFields.forEach(function (nestedField) {
          fn(nestedField);
          visitNestedFields(nestedField, fn);
        });
      }
    };

    exports.visitNestedFields = visitNestedFields;

    var findField = function findField(pages, predicate) {
      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.findField(predicate);
    };

    exports.findField = findField;

    var findFieldByFieldName = function findFieldByFieldName(pages, fieldName) {
      return findField(pages, function (field) {
        return field.fieldName === fieldName;
      });
    };

    exports.findFieldByFieldName = findFieldByFieldName;

    var findFieldByName = function findFieldByName(pages, name) {
      return findField(pages, function (field) {
        return field.name === name;
      });
    };

    exports.findFieldByName = findFieldByName;

    var getRow = function getRow(pages, pageIndex, rowIndex) {
      var currentPage = pages[Number(pageIndex)];
      return currentPage.rows[Number(rowIndex)];
    };

    exports.getRow = getRow;

    var getColumn = function getColumn(pages, pageIndex, rowIndex, columnIndex) {
      var row = getRow(pages, pageIndex, rowIndex);
      return row.columns[Number(columnIndex)];
    };

    exports.getColumn = getColumn;

    var getColumnPosition = function getColumnPosition(pages, pageIndex, rowIndex, columnIndex) {
      var currentPage = pages[pageIndex];
      var currentRow = null;
      currentRow = currentPage.rows[rowIndex];

      if (!currentPage) {
        console.error("Row Index ".concat(rowIndex, " cannot be retrieved from ").concat(currentPage));
        return;
      }

      return columnIndex != -1 && currentRow.columns ? currentRow.columns.reduce(function (result, _, index) {
        if (index <= columnIndex) {
          var column = getColumn(pages, pageIndex, rowIndex, index);
          result += column.size;
        }

        return result;
      }, 0) : 0;
    };

    exports.getColumnPosition = getColumnPosition;

    var getField = function getField(context, pageIndex, rowIndex, columnIndex) {
      var field = getColumn(context, pageIndex, rowIndex, columnIndex).fields[0];

      if (context[pageIndex].nestedFields) {
        field = context[pageIndex].nestedFields.find(function (nestedField) {
          return nestedField.fieldName === field;
        });
      }

      return field;
    };

    exports.getField = getField;

    var getIndexes = function getIndexes(node) {
      var _node$dataset = node.dataset,
          ddmFieldColumn = _node$dataset.ddmFieldColumn,
          ddmFieldPage = _node$dataset.ddmFieldPage,
          ddmFieldRow = _node$dataset.ddmFieldRow;
      return {
        columnIndex: Number(ddmFieldColumn) || 0,
        pageIndex: Number(ddmFieldPage) || 0,
        rowIndex: Number(ddmFieldRow) || 0
      };
    };

    exports.getIndexes = getIndexes;

    var getNestedIndexes = function getNestedIndexes(node) {
      var indexes = [];

      if (node.dataset.ddmFieldRow) {
        indexes = [getIndexes(node)];
      }

      if (!node.parentElement.classList.contains('ddm-form-page')) {
        indexes = [].concat(_toConsumableArray(getNestedIndexes(node.parentElement)), _toConsumableArray(indexes));
      }

      return indexes;
    };

    exports.getNestedIndexes = getNestedIndexes;

    var updateField = function updateField(pages, fieldName, properties) {
      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.mapFields(function (field) {
        if (fieldName === field.fieldName) {
          return _objectSpread(_objectSpread({}, field), properties);
        }

        return field;
      }, true, true);
    };

    exports.updateField = updateField;

    var updateColumn = function updateColumn(pages, pageIndex, rowIndex, columnIndex, properties) {
      var visitor = new _visitors.PagesVisitor(pages);
      return visitor.mapColumns(function (column, currentColumnIndex, currentRowIndex, currentPageIndex) {
        var newColumn = column;

        if (currentColumnIndex === columnIndex && currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
          newColumn = _objectSpread(_objectSpread({}, column), properties);
        }

        return newColumn;
      });
    };

    exports.updateColumn = updateColumn;
    //# sourceMappingURL=FormSupport.es.js.map
  }
});
//# sourceMappingURL=FormSupport.es.js.map