Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.74/js/thunks/previousPage.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/evaluation.es', '../util/formId.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = previousPage;

    var _eventTypes = require("../actions/eventTypes.es");

    var _evaluation = require("../util/evaluation.es");

    var _formId = require("../util/formId.es");

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    function previousPage(_ref) {
      var activePage = _ref.activePage,
          defaultLanguageId = _ref.defaultLanguageId,
          editingLanguageId = _ref.editingLanguageId,
          formId = _ref.formId,
          groupId = _ref.groupId,
          pages = _ref.pages,
          portletNamespace = _ref.portletNamespace,
          rules = _ref.rules;
      var formInstance = document.querySelector("[data-ddmforminstanceid=\"".concat(formId, "\"]"));
      var title = (0, _formId.getFormTitle)(formInstance);
      return function (dispatch) {
        (0, _evaluation.evaluate)(null, {
          defaultLanguageId: defaultLanguageId,
          editingLanguageId: editingLanguageId,
          groupId: groupId,
          pages: pages,
          portletNamespace: portletNamespace,
          rules: rules
        }).then(function (evaluatedPages) {
          var previousActivePageIndex = activePage;

          for (var i = activePage - 1; i > -1; i--) {
            if (evaluatedPages[i].enabled) {
              previousActivePageIndex = i;
              break;
            }
          }

          var activePageUpdated = Math.max(previousActivePageIndex, 0);
          dispatch({
            payload: activePageUpdated,
            type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
          });
          Liferay.fire('ddmFormPageShow', {
            formId: formId,
            formPageTitle: pages[activePageUpdated].title,
            page: activePageUpdated,
            title: title
          });
          var formPagination = document.getElementsByClassName('ddm-form-pagination')[0];
          formPagination.scrollIntoView();
        });
      };
    }
    //# sourceMappingURL=previousPage.es.js.map
  }
});
//# sourceMappingURL=previousPage.es.js.map