Liferay.Loader.define('dynamic-data-mapping-form-renderer@5.0.73/js/util/fields.es', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.normalizeFieldName = normalizeFieldName;
    exports.checkInvalidFieldNameCharacter = void 0;

    /**
     * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
     * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
     */
    var checkInvalidFieldNameCharacter = function checkInvalidFieldNameCharacter(character) {
      return (/[\\~`!@#$%^&*(){}[\];:"'<,.>?/\-+=|]/g.test(character)
      );
    };

    exports.checkInvalidFieldNameCharacter = checkInvalidFieldNameCharacter;

    function normalizeFieldName(fieldName) {
      var nextUpperCase = false;
      var normalizedFieldName = '';
      fieldName = fieldName.trim();

      for (var i = 0; i < fieldName.length; i++) {
        var item = fieldName[i];

        if (item === ' ') {
          nextUpperCase = true;
          continue;
        } else if (checkInvalidFieldNameCharacter(item)) {
          continue;
        }

        if (nextUpperCase) {
          item = item.toUpperCase();
          nextUpperCase = false;
        }

        normalizedFieldName += item;
      }

      if (/^\d/.test(normalizedFieldName)) {
        normalizedFieldName = "_".concat(normalizedFieldName);
      }

      return normalizedFieldName;
    }
    //# sourceMappingURL=fields.es.js.map
  }
});
//# sourceMappingURL=fields.es.js.map