Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.73/js/thunks/fieldChange.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/evaluation.es', '../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = fieldChange;

    var _eventTypes = require("../actions/eventTypes.es");

    var _evaluation = require("../util/evaluation.es");

    var _visitors = require("../util/visitors.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var REVALIDATE_UPDATES = [];

    var getEditedPages = function getEditedPages(_ref) {
      var editingLanguageId = _ref.editingLanguageId,
          name = _ref.name,
          pages = _ref.pages,
          value = _ref.value;
      var pageVisitor = new _visitors.PagesVisitor(pages);
      return pageVisitor.mapFields(function (field) {
        if (field.name === name) {
          return _objectSpread(_objectSpread({}, field), {}, {
            localizedValue: _objectSpread(_objectSpread({}, field.localizedValue), {}, _defineProperty({}, editingLanguageId, value)),
            value: value
          });
        }

        return field;
      }, false, true);
    };

    var lastEditedPages = [];

    function fieldChange(_ref2) {
      var defaultLanguageId = _ref2.defaultLanguageId,
          editingLanguageId = _ref2.editingLanguageId,
          groupId = _ref2.groupId,
          pages = _ref2.pages,
          portletNamespace = _ref2.portletNamespace,
          properties = _ref2.properties,
          rules = _ref2.rules;
      return function (dispatch) // We added an event delay to break long tasks into short
      // durations that are done when `fieldChange` is called
      // very often. That's because changing a fieldEdited is a
      // very expensive operation that causes many renderings in
      // the application.
      {
        var fieldInstance = properties.fieldInstance,
            value = properties.value;
        var evaluable = fieldInstance.evaluable,
            fieldName = fieldInstance.fieldName;
        var editedPages = getEditedPages({
          editingLanguageId: editingLanguageId,
          name: fieldInstance.name,
          pages: pages,
          value: value
        });
        lastEditedPages = editedPages; // We want a synchronous update without waiting for an evaluation of
        // the field.

        dispatch({
          payload: editedPages,
          type: _eventTypes.EVENT_TYPES.UPDATE_PAGES
        }); // We triggered a dispatch of FIELD_CHANGE just to propagate the event to
        // the upper layers.

        dispatch({
          payload: properties,
          type: _eventTypes.EVENT_TYPES.FIELD_CHANGE
        });

        if (evaluable) {
          (0, _evaluation.evaluate)(fieldName, {
            defaultLanguageId: defaultLanguageId,
            editingLanguageId: editingLanguageId,
            groupId: groupId,
            pages: editedPages,
            portletNamespace: portletNamespace,
            rules: rules
          }).then(function (evaluatedPages) {
            if (REVALIDATE_UPDATES.length > 0) {
              // All non-evaluable operations that were performed after the request
              // was sent are used here to revalidate the new data.
              REVALIDATE_UPDATES.forEach(function (item) {
                evaluatedPages = getEditedPages(_objectSpread(_objectSpread({}, item), {}, {
                  pages: evaluatedPages
                }));
              }); // Redefine the list of updates to avoid leaking memory and avoid
              // more expensive operations in the next interactions

              REVALIDATE_UPDATES = [];
            }

            return evaluatedPages;
          }).then(function (evaluatedPages) {
            if (fieldInstance.isDisposed()) {
              return;
            }

            var mergedPages = (0, _evaluation.mergePages)(defaultLanguageId, editingLanguageId, fieldName, evaluatedPages, lastEditedPages);
            dispatch({
              payload: mergedPages,
              type: _eventTypes.EVENT_TYPES.UPDATE_PAGES
            });
            dispatch({
              payload: mergedPages,
              type: _eventTypes.EVENT_TYPES.FIELD_EVALUATED
            });
          }).catch(function (error) {
            return dispatch({
              payload: error,
              type: _eventTypes.EVENT_TYPES.FIELD_EVALUATION_ERROR
            });
          });
        } else {
          REVALIDATE_UPDATES.push({
            editingLanguageId: editingLanguageId,
            name: fieldInstance.name,
            value: value
          });
        }
      };
    }
    //# sourceMappingURL=fieldChange.es.js.map
  }
});
//# sourceMappingURL=fieldChange.es.js.map