Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.41/js/thunks/previousPage.es", ['module', 'exports', 'require', '../actions/eventTypes.es', '../util/evaluation.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = previousPage;

    var _eventTypes = require("../actions/eventTypes.es");

    var _evaluation = require("../util/evaluation.es");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function previousPage(_ref) {
      var activePage = _ref.activePage,
          defaultLanguageId = _ref.defaultLanguageId,
          editingLanguageId = _ref.editingLanguageId,
          formId = _ref.formId,
          pages = _ref.pages,
          portletNamespace = _ref.portletNamespace,
          rules = _ref.rules;
      return function (dispatch) {
        (0, _evaluation.evaluate)(null, {
          defaultLanguageId: defaultLanguageId,
          editingLanguageId: editingLanguageId,
          pages: pages,
          portletNamespace: portletNamespace,
          rules: rules
        }).then(function (evaluatedPages) {
          var previousActivePageIndex = activePage;

          for (var i = activePage - 1; i > -1; i--) {
            if (evaluatedPages[i].enabled) {
              previousActivePageIndex = i;
              break;
            }
          }

          var activePageUpdated = Math.max(previousActivePageIndex, 0);
          dispatch({
            payload: activePageUpdated,
            type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
          });
          Liferay.fire('ddmFormPageShow', {
            formId: formId,
            page: activePageUpdated,
            title: pages[activePageUpdated].title
          });
        });
      };
    }
    //# sourceMappingURL=previousPage.es.js.map
  }
});
//# sourceMappingURL=previousPage.es.js.map